/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;

public final class PurgeIncompletePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Incomplete Files");
    public static final String LABEL = I18n.tr("You can automatically delete old incomplete download files.");
    private final String OPTION_LABEL = I18nMarker.marktr("Days to Keep Incomplete Files:");
    private WholeNumberField _purgeIncompleteField = new SizedWholeNumberField(0, 3, GUIUtils.SizePolicy.RESTRICT_BOTH);

    public PurgeIncompletePaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.OPTION_LABEL, this._purgeIncompleteField, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this._purgeIncompleteField.setValue(SharingSettings.INCOMPLETE_PURGE_TIME.getValue());
    }

    public boolean applyOptions() throws IOException {
        SharingSettings.INCOMPLETE_PURGE_TIME.setValue(this._purgeIncompleteField.getValue());
        return false;
    }

    public boolean isDirty() {
        return SharingSettings.INCOMPLETE_PURGE_TIME.getValue() != this._purgeIncompleteField.getValue();
    }
}

