/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public final class SearchQualityPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Search Result Quality");
    public static final String LABEL = I18n.tr("You can select the \"quality\" of search results to display. Four star results indicate that the host returning the result is not firewalled and has free upload slots.");
    private final JRadioButton FOUR_STAR_BUTTON = new JRadioButton();
    private final JRadioButton THREE_AND_FOUR_STAR_BUTTON = new JRadioButton();
    private final JRadioButton TWO_THREE_AND_FOUR_STAR_BUTTON = new JRadioButton();
    private final JRadioButton ALL_RESULTS_BUTTON = new JRadioButton();

    public SearchQualityPaneItem() {
        super(TITLE, LABEL);
        String fourStarLabelKey = I18nMarker.marktr("Show Only Four Star Results");
        String threeAndFourStarLabelKey = I18nMarker.marktr("Show Only Three and Four Star Results");
        String twoThreeAndFourStarLabelKey = I18nMarker.marktr("Show Only Two, Three, and Four Star Results");
        String showAllResultsLabelKey = I18nMarker.marktr("Show All Qualities");
        String fourStarLabel = I18n.tr(fourStarLabelKey);
        String threeAndFourStarLabel = I18n.tr(threeAndFourStarLabelKey);
        String twoThreeAndFourStarLabel = I18n.tr(twoThreeAndFourStarLabelKey);
        String showAllResultsLabel = I18n.tr(showAllResultsLabelKey);
        this.FOUR_STAR_BUTTON.setText(fourStarLabel);
        this.THREE_AND_FOUR_STAR_BUTTON.setText(threeAndFourStarLabel);
        this.TWO_THREE_AND_FOUR_STAR_BUTTON.setText(twoThreeAndFourStarLabel);
        this.ALL_RESULTS_BUTTON.setText(showAllResultsLabel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.FOUR_STAR_BUTTON);
        group.add(this.THREE_AND_FOUR_STAR_BUTTON);
        group.add(this.TWO_THREE_AND_FOUR_STAR_BUTTON);
        group.add(this.ALL_RESULTS_BUTTON);
        BoxPanel buttonPanel = new BoxPanel();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.FOUR_STAR_BUTTON);
        buttonPanel.add(this.THREE_AND_FOUR_STAR_BUTTON);
        buttonPanel.add(this.TWO_THREE_AND_FOUR_STAR_BUTTON);
        buttonPanel.add(this.ALL_RESULTS_BUTTON);
        this.add(buttonPanel);
    }

    public void initOptions() {
        int minQuality = SearchSettings.MINIMUM_SEARCH_QUALITY.getValue();
        switch (minQuality) {
            case 3: {
                this.FOUR_STAR_BUTTON.setSelected(true);
                break;
            }
            case 2: {
                this.THREE_AND_FOUR_STAR_BUTTON.setSelected(true);
                break;
            }
            case 1: {
                this.TWO_THREE_AND_FOUR_STAR_BUTTON.setSelected(true);
                break;
            }
            default: {
                this.ALL_RESULTS_BUTTON.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        int quality = 3;
        quality = this.FOUR_STAR_BUTTON.isSelected() ? 3 : (this.THREE_AND_FOUR_STAR_BUTTON.isSelected() ? 2 : (this.TWO_THREE_AND_FOUR_STAR_BUTTON.isSelected() ? 1 : 0));
        SearchSettings.MINIMUM_SEARCH_QUALITY.setValue(quality);
        return false;
    }

    public boolean isDirty() {
        switch (SearchSettings.MINIMUM_SEARCH_QUALITY.getValue()) {
            case 3: {
                return !this.FOUR_STAR_BUTTON.isSelected();
            }
            case 2: {
                return !this.THREE_AND_FOUR_STAR_BUTTON.isSelected();
            }
            case 1: {
                return !this.TWO_THREE_AND_FOUR_STAR_BUTTON.isSelected();
            }
            case 0: {
                return !this.ALL_RESULTS_BUTTON.isSelected();
            }
        }
        return true;
    }
}

