/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public final class SearchSpeedPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Search Result Speed");
    public static final String LABEL = I18n.tr("You can select the minimum speed of search results to display.");
    private final JRadioButton T3_BUTTON = new JRadioButton();
    private final JRadioButton T1_BUTTON = new JRadioButton();
    private final JRadioButton CABLE_BUTTON = new JRadioButton();
    private final JRadioButton ALL_BUTTON = new JRadioButton();

    public SearchSpeedPaneItem() {
        super(TITLE, LABEL);
        String t3LabelKey = I18nMarker.marktr("Show Only Results of T3 Speed or Higher");
        String t1LabelKey = I18nMarker.marktr("Show Only Results of T1 Speed or Higher");
        String cableLabelKey = I18nMarker.marktr("Show Only Results of Cable/DSL Speed or Higher");
        String allLabelKey = I18nMarker.marktr("Show All Speeds");
        String t3Label = I18n.tr(t3LabelKey);
        String t1Label = I18n.tr(t1LabelKey);
        String cableLabel = I18n.tr(cableLabelKey);
        String allLabel = I18n.tr(allLabelKey);
        this.T3_BUTTON.setText(t3Label);
        this.T1_BUTTON.setText(t1Label);
        this.CABLE_BUTTON.setText(cableLabel);
        this.ALL_BUTTON.setText(allLabel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.T3_BUTTON);
        group.add(this.T1_BUTTON);
        group.add(this.CABLE_BUTTON);
        group.add(this.ALL_BUTTON);
        BoxPanel buttonPanel = new BoxPanel();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.T3_BUTTON);
        buttonPanel.add(this.T1_BUTTON);
        buttonPanel.add(this.CABLE_BUTTON);
        buttonPanel.add(this.ALL_BUTTON);
        this.add(buttonPanel);
    }

    public void initOptions() {
        int minSpeed = SearchSettings.MINIMUM_SEARCH_SPEED.getValue();
        switch (minSpeed) {
            case 3000: {
                this.T3_BUTTON.setSelected(true);
                break;
            }
            case 1000: {
                this.T1_BUTTON.setSelected(true);
                break;
            }
            case 350: {
                this.CABLE_BUTTON.setSelected(true);
                break;
            }
            default: {
                this.ALL_BUTTON.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        int speed = 3;
        speed = this.T3_BUTTON.isSelected() ? 3000 : (this.T1_BUTTON.isSelected() ? 1000 : (this.CABLE_BUTTON.isSelected() ? 350 : 0));
        SearchSettings.MINIMUM_SEARCH_SPEED.setValue(speed);
        return false;
    }

    public boolean isDirty() {
        switch (SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
            case 3000: {
                return !this.T3_BUTTON.isSelected();
            }
            case 1000: {
                return !this.T1_BUTTON.isSelected();
            }
            case 350: {
                return !this.CABLE_BUTTON.isSelected();
            }
            case 0: {
                return !this.ALL_BUTTON.isSelected();
            }
        }
        return true;
    }
}

