/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.StatusBarSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class StatusBarBandwidthPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Bandwidth Indicator");
    public static final String LABEL = I18n.tr("You can display your bandwidth consumption in the status bar.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Show Bandwidth Indicator:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public StatusBarBandwidthPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue());
    }

    public boolean applyOptions() throws IOException {
        if (!this.isDirty()) {
            return false;
        }
        StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.setValue(this.CHECK_BOX.isSelected());
        GUIMediator.instance().getStatusLine().refresh();
        return false;
    }

    public boolean isDirty() {
        return StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

