/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractDirPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class StoreSaveDirPaneItem
extends AbstractDirPaneItem {
    public static final String TITLE = I18n.tr("LimeWire Store - Save Folder");
    public static final String LABEL = I18n.tr("You can choose the folder for saving files purchased from the LimeWire Store.");

    public StoreSaveDirPaneItem() {
        super(TITLE, LABEL);
    }

    public void initOptions() {
        try {
            File file = SharingSettings.getSaveLWSDirectory();
            if (file == null) {
                throw new FileNotFoundException();
            }
            this.setDirectoryPath(file.getCanonicalPath());
        }
        catch (FileNotFoundException fnfe) {
            this.setDirectoryPath("");
        }
        catch (IOException ioe) {
            this.setDirectoryPath("");
        }
    }

    public String getDefaultPath() {
        return SharingSettings.DEFAULT_SAVE_LWS_DIR.getAbsolutePath();
    }

    public boolean applyOptions() throws IOException {
        String save = this.saveField.getText();
        if (!save.equals(this.saveDirectory)) {
            try {
                File saveDir = new File(save);
                if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
                    throw new IOException();
                }
                SharingSettings.setSaveLWSDirectory(saveDir);
                this.saveDirectory = save;
            }
            catch (IOException ioe) {
                GUIMediator.showError(I18n.tr("Invalid folder for saving files. Please use another folder or revert to the default."));
                this.saveField.setText(this.saveDirectory);
                throw new IOException();
            }
            catch (NullPointerException npe) {
                GUIMediator.showError(I18n.tr("Invalid folder for saving files. Please use another folder or revert to the default."));
                this.saveField.setText(this.saveDirectory);
                throw new IOException();
            }
        }
        return false;
    }

    public boolean isDirty() {
        return !SharingSettings.getSaveLWSDirectory().equals(new File(this.saveField.getText()));
    }
}

