/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.playlist.PlaylistDataLine;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaylistModel
extends BasicDataLineModel<PlaylistDataLine, PlayListItem> {
    private boolean _shuffle = false;
    private boolean _nextIsBefore = false;
    private PlayListItem _currentSong;
    private List<PlayListItem> _songsNotPlayed;

    PlaylistModel() {
        super(PlaylistDataLine.class);
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    @Override
    public PlaylistDataLine createDataLine() {
        return new PlaylistDataLine();
    }

    @Override
    public int add(PlayListItem o) {
        return this.add(o, this.getRowCount());
    }

    @Override
    public int add(PlaylistDataLine dl, int row) {
        if (this._shuffle) {
            this._songsNotPlayed.add((PlayListItem)dl.getInitializeObject());
            Collections.shuffle(this._songsNotPlayed);
        }
        return super.add(dl, row);
    }

    @Override
    public void remove(int i) {
        PlayListItem f = (PlayListItem)((PlaylistDataLine)this.get(i)).getInitializeObject();
        super.remove(i);
        if (this._shuffle) {
            this._songsNotPlayed.remove(f);
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this._shuffle) {
            this._songsNotPlayed.clear();
        }
    }

    PlayListItem getNextSong() {
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return null;
        }
        boolean prior = this._nextIsBefore;
        this._nextIsBefore = false;
        if (this._shuffle) {
            if (this._songsNotPlayed.isEmpty()) {
                for (int i = 0; i < rowCount; ++i) {
                    this._songsNotPlayed.add((PlayListItem)((PlaylistDataLine)this.get(i)).getInitializeObject());
                }
                Collections.shuffle(this._songsNotPlayed);
            }
            this._currentSong = this._songsNotPlayed.remove(0);
        } else {
            int idx = this.getRow(this._currentSong);
            idx = idx == -1 ? 0 : (prior ? (idx - 1 + rowCount) % rowCount : (idx + 1 + rowCount) % rowCount);
            this._currentSong = (PlayListItem)((PlaylistDataLine)this.get(idx)).getInitializeObject();
        }
        return this._currentSong;
    }

    void setCurrentSong(PlayListItem f) {
        if (this._shuffle) {
            this._songsNotPlayed.remove(f);
        }
        this._currentSong = f;
    }

    int getCurrentSongIndex() {
        return this.getRow(this._currentSong);
    }

    List<PlayListItem> getSongs() {
        LinkedList<PlayListItem> l = new LinkedList<PlayListItem>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            l.add((PlayListItem)((PlaylistDataLine)this.get(i)).getInitializeObject());
        }
        return l;
    }

    List<PlayListItem> getLocalFiles() {
        LinkedList<PlayListItem> l = new LinkedList<PlayListItem>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((PlaylistDataLine)this.get(i)).getPlayListItem().isFile()) continue;
            l.add(((PlaylistDataLine)this.get(i)).getPlayListItem());
        }
        return l;
    }

    void setBackwardsMode() {
        this._nextIsBefore = true;
    }

    void addSongs(PlayList list) {
        this.unsort();
        List<PlayListItem> songs = list.getSongs();
        for (PlayListItem item : songs) {
            this.add(item);
        }
    }

    void setShuffle(boolean shuffle) {
        this._songsNotPlayed = shuffle ? new LinkedList<PlayListItem>() : null;
        this._shuffle = shuffle;
    }

    public boolean isShuffleSet() {
        return this._shuffle;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }
}

