/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchResult;
import org.limewire.collection.ApproximateMatcher;
import org.limewire.util.I18NConvert;

abstract class AbstractSearchResult
implements SearchResult {
    private String processedFilename;

    AbstractSearchResult() {
    }

    public String getFilenameNoExtension() {
        String fullname = this.getFileName();
        if (fullname == null) {
            throw new NullPointerException("getFileName() can't return a null result");
        }
        int i = fullname.lastIndexOf(".");
        if (i < 0) {
            return fullname;
        }
        return I18NConvert.instance().compose(fullname.substring(0, i));
    }

    public String getExtension() {
        String fullname = this.getFileName();
        if (fullname == null) {
            throw new NullPointerException("getFileName() can't return a null result");
        }
        int i = fullname.lastIndexOf(".");
        if (i < 0) {
            return "";
        }
        return fullname.substring(i + 1);
    }

    private String getProcessedFilename(ApproximateMatcher matcher) {
        if (this.processedFilename != null) {
            return this.processedFilename;
        }
        this.processedFilename = matcher.process(this.getFilenameNoExtension());
        return this.processedFilename;
    }

    public final int match(SearchResult sr, ApproximateMatcher matcher) {
        long thatSize;
        if (!(sr instanceof AbstractSearchResult)) {
            return 3;
        }
        AbstractSearchResult o = (AbstractSearchResult)sr;
        if (!this.getExtension().equals(o.getExtension())) {
            return 1;
        }
        long thisSize = this.getSize();
        if (thisSize != (thatSize = o.getSize())) {
            return 2;
        }
        this.getProcessedFilename(matcher);
        o.getProcessedFilename(matcher);
        int allowedDifferences = Math.round(Math.min(0.1f * (float)this.getFilenameNoExtension().length(), 0.1f * (float)o.getFilenameNoExtension().length()));
        allowedDifferences = Math.min(allowedDifferences, 4);
        if (!matcher.matches(this.getProcessedFilename(matcher), o.getProcessedFilename(matcher), allowedDifferences)) {
            return 3;
        }
        return 0;
    }
}

