/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SimpleSpecialResultsDatabaseImpl;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicSpecialResultsDatabaseImpl
extends SimpleSpecialResultsDatabaseImpl {
    private final Map<String, List<Map<String, String>>> keywords2nameValuePairs = new HashMap<String, List<Map<String, String>>>();

    BasicSpecialResultsDatabaseImpl(LimeXMLDocumentFactory limeXMLDocumentFactory, String in) {
        super(limeXMLDocumentFactory);
        this.createDB(in);
    }

    BasicSpecialResultsDatabaseImpl(LimeXMLDocumentFactory limeXMLDocumentFactory) {
        this(limeXMLDocumentFactory, "");
    }

    public final synchronized void reload(String in) {
        this.clearDB();
        this.createDB(in);
    }

    public final boolean isEmpty() {
        return this.keywords2nameValuePairs.isEmpty();
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        for (Map.Entry<String, List<Map<String, String>>> e : this.keywords2nameValuePairs.entrySet()) {
            String term = e.getKey();
            List<Map<String, String>> maps = e.getValue();
            res.append(term).append("\n");
            for (Map<String, String> map : maps) {
                res.append(" ").append(map).append("\n");
            }
        }
        return res.toString();
    }

    @Override
    protected final List<Map<String, String>> getSearchResults(String query) {
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        for (String keyword : this.keywords2nameValuePairs.keySet()) {
            if (!query.equalsIgnoreCase(keyword)) continue;
            List<Map<String, String>> xmls = this.keywords2nameValuePairs.get(keyword);
            res.addAll(xmls);
        }
        return res;
    }

    private void clearDB() {
        this.keywords2nameValuePairs.clear();
    }

    private void createDB(String input) {
        StringTokenizer t = new StringTokenizer(input, "\n", false);
        while (t.hasMoreTokens()) {
            String line = t.nextToken();
            String[] termsAndPayload = line.split("\\|");
            if (termsAndPayload.length < 2) continue;
            String terms = termsAndPayload[0];
            String payload = termsAndPayload[1];
            HashMap<String, String> keysAndValues = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(payload, "\t", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int equalIdx = token.indexOf(61);
                if (equalIdx <= 0 || equalIdx >= token.length() - 1) continue;
                String key = token.substring(0, equalIdx);
                String value = token.substring(equalIdx + 1);
                keysAndValues.put(key, value);
            }
            st = new StringTokenizer(terms, "\t", false);
            while (st.hasMoreTokens()) {
                String term = st.nextToken().trim();
                List<Map<String, String>> lst = this.keywords2nameValuePairs.get(term);
                if (lst == null) {
                    lst = new ArrayList<Map<String, String>>();
                    this.keywords2nameValuePairs.put(term, lst);
                }
                lst.add(keysAndValues);
            }
        }
    }
}

