/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import java.awt.Color;
import java.awt.Graphics;

public final class Ditherer {
    private final int _redT;
    private final int _greenT;
    private final int _blueT;
    private final int _redB;
    private final int _greenB;
    private final int _blueB;
    private int STEPS;
    private boolean fixedSteps;
    private final Color from;
    private final Color to;
    private Shader shader;
    private int orientation;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;

    public Ditherer(int steps, Color from, Color to) {
        this(from, to, 1, new LinearShader(), steps);
        if (steps <= 0) {
            throw new IllegalArgumentException("steps must be greater than zero");
        }
    }

    public Ditherer(Color from, Color to, int orientation, Shader shader) {
        this(from, to, orientation, shader, 0);
    }

    private Ditherer(Color from, Color to, int orientation, Shader shader, int steps) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("not a valid orientation");
        }
        if (steps > 0) {
            this.STEPS = steps;
            this.fixedSteps = true;
        }
        this._redT = from.getRed();
        this._greenT = from.getGreen();
        this._blueT = from.getBlue();
        this._redB = to.getRed();
        this._greenB = to.getGreen();
        this._blueB = to.getBlue();
        this.from = from;
        this.to = to;
        this.shader = shader;
        this.orientation = orientation;
    }

    public Color getFromColor() {
        return this.from;
    }

    public Color getToColor() {
        return this.to;
    }

    public void draw(Graphics g, int height, int width) {
        int dimStep;
        int constantDim;
        int changingDim;
        if (this.orientation == 0) {
            changingDim = width;
            constantDim = height;
        } else {
            changingDim = height;
            constantDim = width;
        }
        if (this.fixedSteps) {
            dimStep = changingDim / this.STEPS;
        } else {
            dimStep = 2;
            this.STEPS = changingDim / dimStep;
        }
        float red = this._redT;
        float green = this._greenT;
        float blue = this._blueT;
        int offset = 0;
        for (int i = 0; i < this.STEPS; ++i) {
            Color c = new Color(Ditherer.round(red), Ditherer.round(green), Ditherer.round(blue));
            g.setColor(c);
            this.drawRect(g, offset, constantDim, dimStep);
            offset += dimStep;
            float value = this.shader.getValue((float)i / (float)this.STEPS);
            red = (float)this._redT + (float)(this._redB - this._redT) * value;
            green = (float)this._greenT + (float)(this._greenB - this._greenT) * value;
            blue = (float)this._blueT + (float)(this._blueB - this._blueT) * value;
        }
        Color c = new Color(Ditherer.round(red), Ditherer.round(green), Ditherer.round(blue));
        g.setColor(c);
        this.drawRect(g, offset, constantDim, changingDim - offset);
    }

    private void drawRect(Graphics g, int offset, int constantDim, int changingDim) {
        if (this.orientation == 1) {
            g.fillRect(0, offset, constantDim, changingDim);
        } else {
            g.fillRect(offset, 0, changingDim, constantDim);
        }
    }

    private static int round(float color) {
        int ret = Math.round(color);
        if (ret < 0) {
            return 0;
        }
        if (ret > 255) {
            return 255;
        }
        return ret;
    }

    public static class PolygonShader
    implements Shader {
        private float exponent;

        public PolygonShader(float exponent) {
            this.exponent = exponent;
        }

        public float getValue(float value) {
            return (float)Math.pow(value, this.exponent);
        }
    }

    public static class LinearShader
    implements Shader {
        public float getValue(float value) {
            return value;
        }
    }

    public static interface Shader {
        public float getValue(float var1);
    }
}

