/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.FilterSettings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EndpointHolder
implements Comparable<EndpointHolder> {
    private static final String MULTIPLE = I18n.tr("Multiple");
    private final String _hostName;
    private final int _port;
    private boolean _isPrivate;
    private String _tag;
    private Set<String> _hosts;

    EndpointHolder(String host, int port, boolean replyToMCast) {
        this._hostName = host;
        this._port = port;
        this._isPrivate = !replyToMCast && GuiCoreMediator.getNetworkInstanceUtils().isPrivateAddress(host);
        this._tag = host;
    }

    void addHost(String host, int port) {
        if (this._hosts == null) {
            this._hosts = new HashSet<String>();
            this._hosts.add(this._hostName + ":" + this._port);
        }
        this._hosts.add(host + ":" + port);
        this._tag = MULTIPLE + " (" + this._hosts.size() + ")";
        this._isPrivate = false;
    }

    void addHosts(Set alts) {
        if (this._hosts == null) {
            this._hosts = new HashSet<String>();
            this._hosts.add(this._hostName + ":" + this._port);
        }
        int added = 0;
        Iterator i = alts.iterator();
        while (i.hasNext() && added++ < FilterSettings.MAX_ALTS_TO_DISPLAY.getValue()) {
            IpPort next = (IpPort)i.next();
            this._hosts.add(next.getAddress() + ":" + next.getPort());
        }
        this._tag = MULTIPLE + " (" + this._hosts.size() + ")";
        this._isPrivate = false;
    }

    Set<String> getHosts() {
        return this._hosts;
    }

    int numLocations() {
        return this._hosts == null ? 1 : this._hosts.size();
    }

    boolean isPrivateAddress() {
        return this._isPrivate;
    }

    public String toString() {
        return this._tag;
    }

    @Override
    public int compareTo(EndpointHolder other) {
        int n1 = this.numLocations();
        int n2 = other.numLocations();
        if (n1 == 1 && n2 == 1) {
            return this._tag.compareTo(other._tag);
        }
        return n1 - n2;
    }
}

