/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.FieldFilter;
import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.PropertyFilter;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SchemaFilter;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.SelectorsHandler;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.xml.sax.SAXException;

class FilterPanel
extends BoxPanel {
    private static int uniqueIdCount = 0;
    private final String ID;
    private final FilterBox BOX_1;
    private final FilterBox BOX_2;
    private final FilterBox BOX_3;
    private final ResultPanel RESULTS;
    private final MetadataModel MODEL;

    public FilterPanel(ResultPanel results) {
        super(1);
        String searchType = results.getMediaType().getMimeType();
        Selector one = SelectorsHandler.getSelector(searchType, 0);
        Selector two = SelectorsHandler.getSelector(searchType, 1);
        Selector three = SelectorsHandler.getSelector(searchType, 2);
        MetadataModel model = results.getMetadataModel();
        this.BOX_1 = new FilterBox(model, one);
        this.BOX_2 = new FilterBox(model, two);
        this.BOX_3 = new FilterBox(model, three);
        this.RESULTS = results;
        this.MODEL = model;
        new MinimizeManager(new SelectorListener());
        this.add(this.BOX_1.getComponent());
        this.add(this.BOX_2.getComponent());
        this.add(this.BOX_3.getComponent());
        this.setMatchingValues(null);
        this.ID = "" + uniqueIdCount++;
    }

    String getUniqueDescription() {
        return this.ID;
    }

    public FilterBox[] getBoxes() {
        return new FilterBox[]{this.BOX_1, this.BOX_2, this.BOX_3};
    }

    private void setMatchingValues(FilterBox box) {
        SearchInformation info = this.RESULTS.getSearchInformation();
        if (info.isKeywordSearch()) {
            LimeXMLDocument doc = null;
            String xml = this.RESULTS.getRichQuery();
            if (xml != null) {
                try {
                    doc = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(xml);
                }
                catch (SAXException se) {
                }
                catch (SchemaNotFoundException snfe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (box != null) {
                this.selectMatchingValues(box, doc, info);
            } else {
                this.selectMatchingValues(this.BOX_1, doc, info);
                this.selectMatchingValues(this.BOX_2, doc, info);
                this.selectMatchingValues(this.BOX_3, doc, info);
            }
        }
    }

    private void selectMatchingValues(FilterBox box, LimeXMLDocument doc, SearchInformation info) {
        if (!box.getSelector().isFieldSelector()) {
            return;
        }
        String query = info.getQuery();
        MediaType media = info.getMediaType();
        String value = null;
        if (doc != null) {
            String schema = box.getSelector().getSchema();
            if (!schema.equals(doc.getSchemaDescription())) {
                return;
            }
            String field = box.getSelector().getValue();
            value = doc.getValue(field);
        } else if (media == MediaType.getAnyTypeMediaType()) {
            value = query;
        }
        if (value != null) {
            box.setRequestedValue(value);
        }
    }

    private class SelectorListener
    implements ListDataListener,
    ListSelectionListener,
    ChangeListener {
        private boolean triggered = false;

        SelectorListener() {
            FilterPanel.this.BOX_1.addSelectionListener(this, this);
            FilterPanel.this.BOX_2.addSelectionListener(this, this);
            FilterPanel.this.BOX_3.addSelectionListener(this, this);
            FilterPanel.this.BOX_1.setSelectorChangeListener(this);
            FilterPanel.this.BOX_2.setSelectorChangeListener(this);
            FilterPanel.this.BOX_3.setSelectorChangeListener(this);
        }

        public void stateChanged(ChangeEvent event) {
            String type = FilterPanel.this.RESULTS.getMediaType().getMimeType();
            SelectorsHandler.setSelector(type, 0, FilterPanel.this.BOX_1.getSelector());
            SelectorsHandler.setSelector(type, 1, FilterPanel.this.BOX_2.getSelector());
            SelectorsHandler.setSelector(type, 2, FilterPanel.this.BOX_3.getSelector());
            if (event != null) {
                FilterBox box = (FilterBox)event.getSource();
                FilterPanel.this.setMatchingValues(box);
            }
        }

        public void valueChanged(ListSelectionEvent event) {
            boolean isAll;
            if (event.getValueIsAdjusting()) {
                return;
            }
            JList source = (JList)event.getSource();
            FilterBox box = null;
            int depth = -1;
            if (source == FilterPanel.this.BOX_1.getList()) {
                box = FilterPanel.this.BOX_1;
                depth = 1;
            } else if (source == FilterPanel.this.BOX_2.getList()) {
                box = FilterPanel.this.BOX_2;
                depth = 2;
            } else if (source == FilterPanel.this.BOX_3.getList()) {
                box = FilterPanel.this.BOX_3;
                depth = 3;
            } else {
                throw new IllegalStateException("invalid source: " + source);
            }
            Selector selector = box.getSelector();
            Object value = box.getSelectedValue();
            boolean bl = isAll = event.getFirstIndex() == 0 && event.getLastIndex() == 0;
            if (isAll || this.selectionChanged(selector, value, depth)) {
                this.updateBoxes(depth, box, true);
            }
        }

        public void contentsChanged(ListDataEvent event) {
            if (this.triggered) {
                return;
            }
            Object source = event.getSource();
            FilterBox box = null;
            int depth = -1;
            if (source == FilterPanel.this.BOX_1.getList().getModel()) {
                depth = -1;
            } else if (source == FilterPanel.this.BOX_2.getList().getModel()) {
                box = FilterPanel.this.BOX_1;
                depth = 0;
            } else if (source == FilterPanel.this.BOX_3.getList().getModel()) {
                box = FilterPanel.this.BOX_2;
                depth = 1;
            } else {
                throw new IllegalStateException("invalid source: " + source);
            }
            if (depth > -1) {
                this.triggered = true;
                this.updateBoxes(depth, box, false);
                this.triggered = false;
            }
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
        }

        private void updateBoxes(int depth, FilterBox box, boolean clear) {
            Object sel2;
            boolean all2;
            boolean all1;
            box.updateTitle();
            Object sel1 = FilterPanel.this.BOX_1.getSelectedValue();
            boolean bl = all1 = sel1 == null || MetadataModel.isAll(sel1);
            if (box == FilterPanel.this.BOX_1) {
                if (all1) {
                    this.allPossible(FilterPanel.this.BOX_2);
                } else {
                    this.changeModel(FilterPanel.this.BOX_1, FilterPanel.this.BOX_2, sel1);
                }
                if (clear) {
                    FilterPanel.this.BOX_2.clearSelection();
                }
            }
            boolean bl2 = all2 = (sel2 = FilterPanel.this.BOX_2.getSelectedValue()) == null || MetadataModel.isAll(sel2);
            if (box == FilterPanel.this.BOX_2 || box == FilterPanel.this.BOX_1) {
                if (all2) {
                    if (all1) {
                        this.allPossible(FilterPanel.this.BOX_3);
                    } else {
                        this.changeModel(FilterPanel.this.BOX_1, FilterPanel.this.BOX_3, sel1);
                    }
                } else {
                    this.changeModel(FilterPanel.this.BOX_2, FilterPanel.this.BOX_3, sel2);
                }
                if (clear) {
                    FilterPanel.this.BOX_3.clearSelection();
                }
            }
        }

        private void allPossible(FilterBox box) {
            box.setModel(FilterPanel.this.MODEL.getListModelMap(box.getSelector()));
        }

        private void changeModel(FilterBox parent, FilterBox child, Object value) {
            child.setModel(FilterPanel.this.MODEL.getIntersection(parent.getModel(), value, FilterPanel.this.MODEL.getListModelMap(child.getSelector())));
        }

        private boolean selectionChanged(Selector selector, Object value, int depth) {
            TableLineFilter lineFilter = null;
            if (value == null || MetadataModel.isAll(value)) {
                lineFilter = AllowFilter.instance();
            } else {
                switch (selector.getSelectorType()) {
                    case 1: {
                        lineFilter = new SchemaFilter((NamedMediaType)value);
                        break;
                    }
                    case 2: {
                        lineFilter = new FieldFilter(selector.getSchema(), selector.getValue(), (XMLValue)value);
                        break;
                    }
                    case 3: {
                        lineFilter = new PropertyFilter(selector.getValue(), value);
                    }
                }
            }
            return FilterPanel.this.RESULTS.filterChanged(lineFilter, depth);
        }
    }

    private class MinimizeManager
    implements ChangeListener {
        final ChangeListener SAVER;

        MinimizeManager(ChangeListener cl) {
            FilterPanel.this.BOX_1.setStateChangeListener(this);
            FilterPanel.this.BOX_2.setStateChangeListener(this);
            FilterPanel.this.BOX_3.setStateChangeListener(this);
            this.SAVER = cl;
            this.stateChanged(null);
        }

        public void stateChanged(ChangeEvent event) {
            boolean one = FilterPanel.this.BOX_1.isMinimized();
            boolean two = FilterPanel.this.BOX_2.isMinimized();
            boolean three = FilterPanel.this.BOX_3.isMinimized();
            if (one && two && three) {
                FilterPanel.this.BOX_1.setStateChangeListener(null);
                FilterPanel.this.BOX_1.restore();
                one = false;
                FilterPanel.this.BOX_1.setStateChangeListener(this);
            }
            if (one && two) {
                FilterPanel.this.BOX_3.setCanMinimize(false);
            } else if (one && three) {
                FilterPanel.this.BOX_2.setCanMinimize(false);
            } else if (two && three) {
                FilterPanel.this.BOX_1.setCanMinimize(false);
            } else {
                FilterPanel.this.BOX_1.setCanMinimize(true);
                FilterPanel.this.BOX_2.setCanMinimize(true);
                FilterPanel.this.BOX_3.setCanMinimize(true);
            }
            FilterPanel.this.removeAll();
            FilterPanel.this.add(FilterPanel.this.BOX_1.getComponent());
            FilterPanel.this.add(FilterPanel.this.BOX_2.getComponent());
            FilterPanel.this.add(FilterPanel.this.BOX_3.getComponent());
            FilterPanel.this.invalidate();
            FilterPanel.this.revalidate();
            FilterPanel.this.repaint();
            this.SAVER.stateChanged(event);
        }
    }
}

