/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.ListModelMap;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.limewire.collection.Comparators;

final class MetadataModel {
    private final ListModelMap MODEL = new Model();
    private static final String UNKNOWN = "unknown";
    private final ListModelMap PROPERTIES = new Model(Comparators.stringComparator());

    MetadataModel() {
        this.initialize();
    }

    void clear() {
        this.MODEL.clear();
        this.PROPERTIES.clear();
        this.initialize();
    }

    void addNew(TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        this.addProperties(line);
        if (mt == null) {
            return;
        }
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        LimeXMLDocument doc = line.getXMLDocument();
        if (doc != null) {
            this.addDocument(fieldMap, mt.getSchema(), doc, line);
        } else {
            this.getCollection(fieldMap, UNKNOWN).add(line);
        }
    }

    void remove(TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        this.removeProperties(line);
        if (mt == null) {
            return;
        }
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        LimeXMLDocument doc = line.getXMLDocument();
        if (doc != null) {
            this.removeDocument(fieldMap, mt.getSchema(), doc, line);
        } else {
            this.getCollection(fieldMap, UNKNOWN).remove(line);
        }
    }

    void addNewDocument(LimeXMLDocument doc, TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        this.addDocument(fieldMap, mt.getSchema(), doc, line);
    }

    void addField(SchemaFieldInfo sfi, String field, String value, TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        ListModelMap valueMap = this.getMapNatural(fieldMap, field);
        this.getCollection(valueMap, new XMLValue(value, sfi)).add(line);
    }

    void updateProperty(String property, Object current, Object old, TableLine line) {
        ListModelMap map = this.getMap(this.PROPERTIES, property);
        this.getCollection(map, old).remove(line);
        this.getCollection(map, current).add(line);
    }

    ListModelMap getListModelMap(Selector selector) {
        switch (selector.getSelectorType()) {
            case 1: {
                return this.MODEL;
            }
            case 2: {
                NamedMediaType mt = NamedMediaType.getFromDescription(selector.getSchema());
                return this.getMapNatural(this.getMap(this.MODEL, mt), selector.getValue());
            }
            case 3: {
                return this.getMap(this.PROPERTIES, selector.getValue());
            }
        }
        return null;
    }

    List getSelectorOptions() {
        LinkedList<Selector> list = new LinkedList<Selector>();
        list.add(Selector.createSchemaSelector());
        for (Map.Entry entry : this.MODEL.entrySet()) {
            NamedMediaType nmt = (NamedMediaType)entry.getKey();
            String schema = nmt.getMediaType().getMimeType();
            for (String next : ((Map)entry.getValue()).keySet()) {
                if (UNKNOWN.equals(next)) continue;
                list.add(Selector.createFieldSelector(schema, next));
            }
        }
        Iterator i = this.PROPERTIES.keySet().iterator();
        while (i.hasNext()) {
            list.add(Selector.createPropertySelector((String)((Object)i.next())));
        }
        return list;
    }

    ListModelMap getIntersection(ListModelMap parent, Object selection, ListModelMap child) {
        Collection elements;
        if (selection != null && !MetadataModel.isAll(selection)) {
            Object values = parent.get(selection);
            if (values == null) {
                throw new IllegalArgumentException("invalid selection");
            }
            elements = this.getAllValues(values);
        } else {
            elements = this.getAllValues(parent);
        }
        Model ret = child.comparator() == null ? new Model() : new Model(child.comparator());
        for (Map.Entry entry : child.entrySet()) {
            if (!DataUtils.containsAny(elements, this.getAllValues(entry.getValue()))) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private void initialize() {
        this.PROPERTIES.put(Selector.PropertyType.TYPE.getKey(), new Model());
        this.PROPERTIES.put(Selector.PropertyType.SPEED.getKey(), new Model());
    }

    private void addDocument(Map fieldMap, LimeXMLSchema schema, LimeXMLDocument doc, TableLine line) {
        boolean added = false;
        for (SchemaFieldInfo sfi : schema.getCanonicalizedFields()) {
            String field = sfi.getCanonicalizedFieldName();
            String value = doc.getValue(field);
            if (value == null) continue;
            added = true;
            ListModelMap valueMap = this.getMapNatural(fieldMap, field);
            this.getCollection(valueMap, new XMLValue(value, sfi)).add(line);
        }
        if (!added) {
            this.getCollection(fieldMap, UNKNOWN).add(line);
        }
    }

    private void removeDocument(Map fieldMap, LimeXMLSchema schema, LimeXMLDocument doc, TableLine line) {
        boolean removed = false;
        for (SchemaFieldInfo sfi : schema.getCanonicalizedFields()) {
            String field = sfi.getCanonicalizedFieldName();
            String value = doc.getValue(field);
            if (value == null) continue;
            removed = true;
            ListModelMap valueMap = this.getMapNatural(fieldMap, field);
            this.getCollection(valueMap, new XMLValue(value, sfi)).remove(line);
        }
        if (!removed) {
            this.getCollection(fieldMap, UNKNOWN).remove(line);
        }
    }

    private void addProperties(TableLine line) {
        ListModelMap extMap = this.getMap(this.PROPERTIES, Selector.PropertyType.TYPE.getKey());
        this.getCollection(extMap, line.getIconAndExtension()).add(line);
        ListModelMap speedMap = this.getMap(this.PROPERTIES, Selector.PropertyType.SPEED.getKey());
        this.getCollection(speedMap, line.getSpeed()).add(line);
        ListModelMap vendorMap = this.getMap(this.PROPERTIES, Selector.PropertyType.VENDOR.getKey());
        this.getCollection(vendorMap, line.getVendor()).add(line);
    }

    private void removeProperties(TableLine line) {
        ListModelMap extMap = this.getMap(this.PROPERTIES, Selector.PropertyType.TYPE.getKey());
        this.getCollection(extMap, line.getIconAndExtension()).remove(line);
        ListModelMap speedMap = this.getMap(this.PROPERTIES, Selector.PropertyType.SPEED.getKey());
        this.getCollection(speedMap, line.getSpeed()).remove(line);
        ListModelMap vendorMap = this.getMap(this.PROPERTIES, Selector.PropertyType.VENDOR.getKey());
        this.getCollection(vendorMap, line.getVendor()).remove(line);
    }

    private Collection getAllValues(Object parent) {
        if (parent instanceof Collection) {
            return (Collection)parent;
        }
        if (parent instanceof Map) {
            HashSet values = new HashSet();
            Iterator i = ((Map)parent).values().iterator();
            while (i.hasNext()) {
                values.addAll(this.getAllValues(i.next()));
            }
            return values;
        }
        throw new IllegalArgumentException("parent: " + parent);
    }

    private ListModelMap getMap(Map parent, Object key) {
        ListModelMap m = (ListModelMap)parent.get(key);
        if (m == null) {
            m = new Model(Comparators.caseInsensitiveStringComparator());
            parent.put(key, m);
        }
        return m;
    }

    private ListModelMap getMapNatural(Map parent, Object key) {
        ListModelMap m = (ListModelMap)parent.get(key);
        if (m == null) {
            m = new Model();
            parent.put(key, m);
        }
        return m;
    }

    private Collection getCollection(Map parent, Object key) {
        HashSet l;
        if (key instanceof String) {
            key = ((String)key).trim();
        }
        if ((l = (HashSet)parent.get(key)) == null) {
            l = new HashSet();
            parent.put(key, l);
        }
        return l;
    }

    static boolean isAll(Object value) {
        return value instanceof All;
    }

    private static class All {
        private static final String ALL = I18n.tr("All") + " (";
        final int number;

        private All(int number) {
            this.number = number;
        }

        public String toString() {
            return ALL + this.number + ")";
        }
    }

    private static class SimpleListModel
    extends AbstractListModel {
        private SimpleListModel() {
        }

        public int getSize() {
            throw new IllegalStateException();
        }

        public Object getElementAt(int idx) {
            throw new IllegalStateException();
        }

        public void fireContentsChanged(Object src, int a, int b) {
            super.fireContentsChanged(src, a, b);
        }
    }

    private static class Model
    extends TreeMap
    implements ListModelMap {
        private final SimpleListModel DELEGATE = new SimpleListModel();

        Model() {
        }

        Model(Comparator comp) {
            super(comp);
        }

        public Object put(Object a, Object b) {
            Object o = super.put(a, b);
            this.DELEGATE.fireContentsChanged(this, 0, this.size());
            return o;
        }

        public void fireContentsChanged() {
            this.DELEGATE.fireContentsChanged(this, 0, this.size());
        }

        public void addListDataListener(ListDataListener l) {
            this.DELEGATE.addListDataListener(l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.DELEGATE.removeListDataListener(l);
        }

        public int getSize() {
            return this.size() + 1;
        }

        public Object getElementAt(int idx) {
            if (idx == 0) {
                return new All(this.size());
            }
            if (idx > this.size()) {
                throw new IndexOutOfBoundsException("index: " + idx + ", size: " + this.getSize());
            }
            Iterator i = this.keySet().iterator();
            for (int j = 1; j < idx; ++j) {
                i.next();
            }
            return i.next();
        }

        public boolean contains(Object o) {
            if (MetadataModel.isAll(o)) {
                return true;
            }
            return this.containsKey(o);
        }

        public int indexOf(Object o) {
            if (MetadataModel.isAll(o)) {
                return 0;
            }
            Iterator iter = this.keySet().iterator();
            int i = 1;
            while (iter.hasNext()) {
                if (this.compare(o, iter.next()) == 0) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Iterator iterator() {
            return this.keySet().iterator();
        }

        private int compare(Object k1, Object k2) {
            return this.comparator() == null ? ((Comparable)k1).compareTo(k2) : this.comparator().compare(k1, k2);
        }
    }
}

