/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.OverlayLayout;

public class OverlayAd
extends JPanel
implements ThemeObserver {
    private final Icon CLOSER;
    private ImageIcon _image = null;
    private boolean _searchDone;
    private final Future<Void> introFuture;
    private UISettings.ImageInfo introInfo = UISettings.INTRO_IMAGE_INFO;
    private UISettings.ImageInfo afterSearchInfo = UISettings.AFTER_SEARCH_IMAGE_INFO;

    OverlayAd() {
        this.setLayout(new OverlayLayout(this));
        this.CLOSER = GUIMediator.getThemeImage("kill_on");
        LoadImageThenRun runner = new LoadImageThenRun(this.introInfo, new LateImageRunner(){

            public void runWithImage(ImageIcon img, boolean usingBackup) {
                if (OverlayAd.this._image != null) {
                    return;
                }
                OverlayAd.this._image = img;
                Dimension preferredSize = new Dimension(OverlayAd.this._image.getIconWidth(), OverlayAd.this._image.getIconHeight());
                OverlayAd.this.setMaximumSize(preferredSize);
                OverlayAd.this.setPreferredSize(preferredSize);
                try {
                    if (usingBackup) {
                        OverlayAd.this.add(OverlayAd.this.createTextPanel(OverlayAd.this.introInfo));
                    } else if (!OverlayAd.this.afterSearchInfo.canProShowPic() && LimeWireUtils.isPro()) {
                        OverlayAd.this.add(OverlayAd.this.createCloserPanel());
                    }
                    OverlayAd.this.add(OverlayAd.this.createImagePanel(OverlayAd.this.getUrl(OverlayAd.this.introInfo, usingBackup), OverlayAd.this.introInfo.getTorrentUrl()));
                    GUIUtils.setOpaque(false, OverlayAd.this);
                }
                catch (NullPointerException npe) {
                    OverlayAd.this.setVisible(false);
                    OverlayAd.this._searchDone = true;
                }
            }
        }, "intro");
        this.introFuture = runner.run();
    }

    public void updateIntroInfo(UISettings.ImageInfo newIntro) {
        UISettings.INTRO_IMAGE_INFO = this.introInfo = newIntro;
        UISettings.instance().save();
    }

    public void updateAfterSearchInfo(UISettings.ImageInfo newAfterSearchInfo) {
        UISettings.AFTER_SEARCH_IMAGE_INFO = this.afterSearchInfo = newAfterSearchInfo;
        UISettings.instance().save();
    }

    public void updateTheme() {
        GUIUtils.setOpaque(false, this);
    }

    void searchPerformed() {
        if (this._searchDone) {
            System.out.println("OverlayAd.searchPerformed() - already did it sorry");
            return;
        }
        this._searchDone = true;
        LoadImageThenRun runner = new LoadImageThenRun(this.afterSearchInfo, new LateImageRunner(){

            public void runWithImage(ImageIcon img, boolean usingBackup) {
                OverlayAd.this.introFuture.cancel(false);
                OverlayAd.this._image = img;
                Dimension preferredSize = new Dimension(OverlayAd.this._image.getIconWidth(), OverlayAd.this._image.getIconHeight());
                OverlayAd.this.setMaximumSize(preferredSize);
                OverlayAd.this.setPreferredSize(preferredSize);
                try {
                    OverlayAd.this.removeAll();
                    if (usingBackup) {
                        OverlayAd.this.add(OverlayAd.this.createTextPanel(OverlayAd.this.afterSearchInfo));
                    }
                    OverlayAd.this.add(OverlayAd.this.createImagePanel(OverlayAd.this.getUrl(OverlayAd.this.afterSearchInfo, usingBackup), OverlayAd.this.afterSearchInfo.getTorrentUrl()));
                    GUIUtils.setOpaque(false, OverlayAd.this);
                }
                catch (NullPointerException npe) {
                    OverlayAd.this.setVisible(false);
                    OverlayAd.this._searchDone = true;
                }
            }
        }, "afterSearch");
        runner.run();
    }

    private String getUrl(UISettings.ImageInfo info, boolean backup) {
        if (!info.canLink()) {
            return null;
        }
        if (backup) {
            return info.getLocalLinkUrl();
        }
        return info.getNetworkLinkUrl();
    }

    private JPanel createImagePanel(String url, String torrentUrl) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(this._image), "Center");
        panel.setMaximumSize(this.getMaximumSize());
        panel.setPreferredSize(this.getPreferredSize());
        panel.addMouseListener(new Launcher(url, torrentUrl));
        return panel;
    }

    private JPanel createTextPanel(UISettings.ImageInfo info) {
        JPanel panel = new JPanel(new BorderLayout());
        if (LimeWireUtils.isPro() || !info.isIntro()) {
            panel.add((Component)this.createNorthPanel(LimeWireUtils.isPro()), "North");
        }
        panel.add(Box.createHorizontalStrut(18), "West");
        JPanel center = !info.isIntro() ? this.createGoProCenter() : this.createGettingStartedCenter();
        panel.add((Component)center, "Center");
        panel.add(Box.createHorizontalStrut(18), "East");
        panel.setMaximumSize(this.getMaximumSize());
        panel.setPreferredSize(this.getPreferredSize());
        return panel;
    }

    private JPanel createCloserPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createNorthPanel(false), "North");
        return panel;
    }

    private JPanel createNorthPanel(boolean useCloser) {
        BoxPanel box = new BoxPanel(0);
        box.add(Box.createHorizontalGlue());
        if (useCloser) {
            JLabel closer = new JLabel(this.CLOSER);
            closer.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    OverlayAd.this.setVisible(false);
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
            box.add(closer);
        } else {
            box.add(Box.createVerticalStrut(this.CLOSER.getIconHeight()));
        }
        return box;
    }

    private JPanel createGettingStartedCenter() {
        JLabel title = new JLabel(I18n.tr("Getting Started"));
        title.setFont(new Font("Dialog", 0, 24));
        title.setForeground(new Color(90, 118, 148));
        JTextArea text = new JTextArea(I18n.tr("To start using FrostWire, find the text field on the left, type in what you are looking for and click the \"Search\" button. If you are looking for only one type of content (music, video, etc...), you can narrow your search results by using the buttons above the text field."));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setOpaque(false);
        text.setForeground(new Color(0, 0, 0));
        text.setFont(new Font("Dialog", 0, 14));
        JScrollPane pane = new JScrollPane(text);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        JPanel box = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(40, 0, 5, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.anchor = 18;
        box.add((Component)title, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        box.add((Component)pane, c);
        String url = this.getUrl(this.introInfo, true);
        if (url != null && !url.equals("")) {
            Launcher launcher = new Launcher(url, null);
            box.addMouseListener(launcher);
            text.addMouseListener(launcher);
            title.addMouseListener(launcher);
            this.addMouseListener(launcher);
        }
        return box;
    }

    private JPanel createGoProCenter() {
        JLabel title = new JLabel(I18n.tr("Free, Fastest, Uncensored, Safe and Ad Free File Sharing"));
        title.setFont(new Font("Dialog", 1, 16));
        title.setForeground(new Color(67, 67, 67));
        JTextArea text = new JTextArea(I18n.tr("Better search results\nTurbo-Charged download speeds\nConnections to more sources\nPersonalized tech support\nSix months of free updates"));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setOpaque(false);
        text.setForeground(new Color(67, 67, 67));
        text.setFont(new Font("Dialog", 0, 14));
        BoxPanel textPanel = new BoxPanel(0);
        textPanel.add(Box.createHorizontalStrut(185));
        textPanel.add(text);
        BoxPanel box = new BoxPanel(1);
        box.add(GUIUtils.center(title));
        box.add(Box.createVerticalStrut(80));
        box.add(textPanel);
        String url = this.getUrl(this.afterSearchInfo, true);
        if (url != null && !url.equals("")) {
            Launcher launcher = new Launcher(url, this.afterSearchInfo.getTorrentUrl());
            box.addMouseListener(launcher);
            text.addMouseListener(launcher);
            title.addMouseListener(launcher);
            textPanel.addMouseListener(launcher);
        }
        return box;
    }

    private static interface LateImageRunner {
        public void runWithImage(ImageIcon var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoadImageThenRun {
        private final UISettings.ImageInfo imageInfo;
        private final LateImageRunner runner;
        private final String backupImage;

        public LoadImageThenRun(UISettings.ImageInfo imageInfo, LateImageRunner runner, String backupImage) {
            this.imageInfo = imageInfo;
            this.runner = runner;
            this.backupImage = backupImage;
        }

        private ImageIcon image() {
            String url = this.imageInfo.getImageUrl();
            if (!this.imageInfo.useNetworkImage() || url == null || url.length() == 0) {
                return new ImageIcon();
            }
            try {
                byte[] guid = GuiCoreMediator.getApplicationServices().getMyGUID();
                url = LimeWireUtils.addLWInfoToUrl(url, guid);
                return new ImageIcon(new URL(url));
            }
            catch (MalformedURLException murl) {
                return new ImageIcon();
            }
        }

        Future<Void> run() {
            return BackgroundExecutorService.submit(new Callable<Void>(){

                @Override
                public Void call() {
                    boolean usingBackup;
                    ImageIcon img = LoadImageThenRun.this.image();
                    if (img.getIconHeight() <= 0 || img.getIconHeight() <= 0) {
                        usingBackup = true;
                        img = GUIMediator.getThemeImage(LoadImageThenRun.this.backupImage);
                    } else {
                        usingBackup = false;
                    }
                    final ImageIcon finalImg = img;
                    GUIMediator.safeInvokeLater(new Runnable(){

                        public void run() {
                            LoadImageThenRun.this.runner.runWithImage(finalImg, usingBackup);
                        }
                    });
                    return null;
                }
            });
        }
    }

    private static class Launcher
    implements MouseListener {
        private final String url;
        private final String torrentUrl;

        Launcher(String url, String torrentUrl) {
            this.url = url;
            this.torrentUrl = torrentUrl;
        }

        public void mouseClicked(MouseEvent e) {
            if (!e.isConsumed()) {
                e.consume();
                byte[] guid = GuiCoreMediator.getApplicationServices().getMyGUID();
                String finalUrl = LimeWireUtils.addLWInfoToUrl(this.url, guid);
                System.out.println("URL is " + this.url);
                System.out.println("TORRENT is " + this.torrentUrl);
                if (this.url != null && !this.url.equals("")) {
                    GUIMediator.openURL(finalUrl);
                }
                if (this.torrentUrl != null && !this.torrentUrl.equals("")) {
                    this.openTorrent(this.torrentUrl);
                }
            }
        }

        public void openTorrent(String uriStr) {
            if (uriStr == null || uriStr.equals("")) {
                return;
            }
            try {
                URI uri = new URI(uriStr);
                String scheme = uri.getScheme();
                if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                    return;
                }
                String authority = uri.getAuthority();
                if (authority == null || authority.equals("") || authority.indexOf(32) != -1) {
                    return;
                }
                GUIMediator.instance().openTorrentURI(uri);
            }
            catch (URISyntaxException e) {
                System.out.println(e);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            ((JComponent)e.getComponent()).getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent e) {
            ((JComponent)e.getComponent()).getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        }
    }
}

