/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.I18n;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchInformation {
    private static final String MAP_TYPE = "type";
    private static final String MAP_QUERY = "query";
    private static final String MAP_XML = "xml";
    private static final String MAP_MEDIA = "media";
    private static final String MAP_TITLE = "title";
    public static final int KEYWORD = 0;
    public static final int WHATS_NEW = 1;
    public static final int BROWSE_HOST = 2;
    public static final String WHATS_NEW_DESC = I18n.tr("New");
    private final int type;
    private final String query;
    private final String xml;
    private final MediaType media;
    private final String title;

    private SearchInformation(int type, String query, String xml, MediaType media, String title) {
        if (media == null) {
            throw new NullPointerException("null media");
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        this.type = type;
        this.query = query.trim();
        this.xml = xml;
        this.media = media;
        this.title = title != null ? title : query;
    }

    private SearchInformation(int type, String query, String xml, MediaType media) {
        this(type, query, xml, media, null);
    }

    private SearchInformation(Map map) {
        Integer type = (Integer)map.get(MAP_TYPE);
        if (type == null) {
            throw new NullPointerException("null type");
        }
        this.type = type;
        this.query = (String)map.get(MAP_QUERY);
        this.xml = (String)map.get(MAP_XML);
        this.media = (MediaType)map.get(MAP_MEDIA);
        this.title = (String)map.get(MAP_TITLE);
        if (this.media == null) {
            throw new NullPointerException("null media");
        }
        if (this.query == null) {
            throw new NullPointerException("null query");
        }
    }

    public static SearchInformation createKeywordSearch(String query, String xml, MediaType media) {
        return new SearchInformation(0, query, xml, media);
    }

    public static SearchInformation createTitledKeywordSearch(String query, String xml, MediaType media, String title) {
        return new SearchInformation(0, query, xml, media, title);
    }

    public static SearchInformation createWhatsNewSearch(String name, MediaType type) {
        return new SearchInformation(1, WHATS_NEW_DESC + " - " + name, null, type);
    }

    public static SearchInformation createBrowseHostSearch(String desc) {
        return new SearchInformation(2, desc, null, MediaType.getAnyTypeMediaType());
    }

    public String getQuery() {
        return this.query;
    }

    public String getXML() {
        return this.xml;
    }

    public MediaType getMediaType() {
        return this.media;
    }

    public String getTitle() {
        return this.title;
    }

    IpPort getIpPort() {
        if (!this.isBrowseHostSearch()) {
            throw new IllegalStateException();
        }
        StringTokenizer st = new StringTokenizer(this.getQuery(), ":");
        String host = null;
        int port = 6346;
        if (st.hasMoreTokens()) {
            host = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            try {
                port = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return new IpPortImpl(InetSocketAddress.createUnresolved(host, port), host);
    }

    public boolean isXMLSearch() {
        return this.xml != null && this.xml.length() > 0;
    }

    public boolean isKeywordSearch() {
        return this.type == 0;
    }

    public boolean isWhatsNewSearch() {
        return this.type == 1;
    }

    public boolean isBrowseHostSearch() {
        return this.type == 2;
    }

    public String toString() {
        return this.toMap().toString();
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(5);
        map.put(MAP_TYPE, new Integer(this.type));
        map.put(MAP_QUERY, (Serializable)((Object)this.query));
        map.put(MAP_XML, (Serializable)((Object)this.xml));
        map.put(MAP_MEDIA, this.media);
        map.put(MAP_TITLE, (Serializable)((Object)this.title));
        return map;
    }

    public static SearchInformation createFromMap(Map map) {
        return new SearchInformation(map);
    }
}

