/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.search.FilterInputPanel;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInputPanel;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class SearchInputManager
implements ThemeObserver {
    private final JPanel COMPONENT_PANEL = new JPanel(new GridBagLayout());
    private final CardLayout MAIN_CARDS = new CardLayout();
    private final JPanel MAIN_PANEL = new JPanel(this.MAIN_CARDS);
    private SearchInputPanel SEARCH;
    private FilterInputPanel FILTER;

    SearchInputManager() {
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        this.SEARCH = new SearchInputPanel(GuiCoreMediator.getNetworkManager(), GuiCoreMediator.getNetworkInstanceUtils());
        this.FILTER = new FilterInputPanel(new ShowSearchListener(), new AutoSearchListener());
        this.MAIN_PANEL.removeAll();
        this.MAIN_PANEL.add((Component)this.SEARCH, "search");
        this.MAIN_PANEL.add((Component)this.FILTER, "filter");
        this.COMPONENT_PANEL.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.COMPONENT_PANEL.add((Component)this.MAIN_PANEL, c);
    }

    void rebuild() {
        this.updateTheme();
    }

    void addressChanged() {
        this.SEARCH.addressChanged();
    }

    void goToSearch() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchInputManager.this.showSearchCard(false);
            }
        });
    }

    void requestSearchFocus() {
        this.requestSearchFocus(false);
    }

    JComponent getComponent() {
        return this.COMPONENT_PANEL;
    }

    void clearFilters() {
        this.FILTER.clearFilters();
        this.showSearchCard(false);
    }

    void panelReset(ResultPanel rp) {
        this.FILTER.panelReset(rp);
    }

    void panelRemoved(ResultPanel rp) {
        if (this.FILTER.panelRemoved(rp)) {
            this.showSearchCard(false);
        }
    }

    void setFiltersFor(ResultPanel rp) {
        if (UISettings.SEARCH_RESULT_FILTERS.getValue()) {
            boolean added = this.FILTER.setFiltersFor(rp);
            this.MAIN_CARDS.last(this.MAIN_PANEL);
            if (added) {
                this.requestFilterFocus();
            }
        }
    }

    private void showSearchCard(boolean immediate) {
        this.MAIN_CARDS.first(this.MAIN_PANEL);
        this.requestSearchFocus(immediate);
    }

    private void requestSearchFocus(boolean immediate) {
        if (immediate) {
            this.SEARCH.requestSearchFocusImmediately();
        } else {
            this.SEARCH.requestSearchFocus();
        }
    }

    private void requestFilterFocus() {
        this.FILTER.requestFilterFocus();
    }

    private class AutoSearchListener
    implements KeyListener {
        private AutoSearchListener() {
        }

        public void keyPressed(KeyEvent e) {
            this.forward(e);
        }

        public void keyReleased(KeyEvent e) {
            this.forward(e);
        }

        public void keyTyped(KeyEvent e) {
            if (this.forward(e)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchInputManager.this.showSearchCard(true);
                    }
                });
            }
        }

        private boolean forward(KeyEvent e) {
            if (SearchInputManager.this.SEARCH.isKeyEventForwardable()) {
                SearchInputManager.this.SEARCH.getForwardingSearchField().processKeyEvent(e);
                return true;
            }
            return false;
        }
    }

    private class ShowSearchListener
    implements ActionListener {
        private ShowSearchListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchInputManager.this.goToSearch();
        }
    }
}

