/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.ThirdPartyResultsDatabase;
import com.limegroup.gnutella.gui.search.ThirdPartySearchResult;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SimpleSpecialResultsDatabaseImpl
implements ThirdPartyResultsDatabase {
    private static final Log LOG = LogFactory.getLog(SimpleSpecialResultsDatabaseImpl.class);
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;

    protected abstract List<Map<String, String>> getSearchResults(String var1);

    protected SimpleSpecialResultsDatabaseImpl(LimeXMLDocumentFactory limeXMLDocumentFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
    }

    @Override
    public final void find(SearchInformation info, ThirdPartyResultsDatabase.SearchResultsCallback callback) {
        if (!this.beforeFind()) {
            return;
        }
        String query = info.getQuery();
        this.find(query, info, callback);
    }

    void find(String query, SearchInformation info, ThirdPartyResultsDatabase.SearchResultsCallback callback) {
        ArrayList<SearchResult> res = new ArrayList<SearchResult>();
        if (query != null) {
            String lc = query.toLowerCase();
            List<Map<String, String>> nameValuePairsList = this.getSearchResults(lc);
            for (Map<String, String> nameValuePairs : nameValuePairsList) {
                Collection<NameValue<String>> xmlValues;
                SearchResult sr;
                String url = nameValuePairs.get("url");
                int size = (int)this.getOrDefaultWithMax(nameValuePairs, "size", -1L, Integer.MAX_VALUE);
                long creationTime = this.getOrDefaultWithMax(nameValuePairs, "creation_time", 0L, Long.MAX_VALUE);
                String vendor = nameValuePairs.get("vendor");
                String name = nameValuePairs.get("name");
                String fileType = nameValuePairs.get("fileType");
                String xmlSchema = nameValuePairs.get("xmlSchema");
                if (xmlSchema == null) {
                    xmlSchema = "audio";
                }
                if ((sr = this.newSearchResult(name, fileType, xmlSchema, url, size, creationTime, vendor, xmlValues = this.xmlValuesIn(nameValuePairs, xmlSchema), query)) == null || name == null) continue;
                res.add(sr);
            }
        }
        callback.process(res, info);
    }

    private Collection<NameValue<String>> xmlValuesIn(Map<String, String> allNameValues, String xmlSchema) {
        String plural = xmlSchema + "s";
        ArrayList<NameValue<String>> xmlValues = new ArrayList<NameValue<String>>();
        for (Map.Entry<String, String> entry : allNameValues.entrySet()) {
            if (!entry.getKey().startsWith("xml_")) continue;
            xmlValues.add(new NameValue<String>(plural + "__" + xmlSchema + "__" + entry.getKey().substring(4) + "__", entry.getValue()));
        }
        return xmlValues;
    }

    protected boolean beforeFind() {
        return true;
    }

    private SearchResult newSearchResult(String name, String fileType, String xmlSchema, String url, int size, long creationTime, String vendor, Collection<NameValue<String>> xmlValues, String keyword) {
        LimeXMLDocument xmlDoc = null;
        if (xmlValues.size() > 0) {
            try {
                xmlDoc = this.limeXMLDocumentFactory.createLimeXMLDocument(xmlValues, "http://www.limewire.com/schemas/" + xmlSchema + ".xsd");
            }
            catch (IllegalArgumentException iae) {
                LOG.error("error creating document", iae);
            }
        }
        return new ThirdPartySearchResult(name, fileType, url, size, creationTime, xmlDoc, vendor, keyword);
    }

    private long getOrDefaultWithMax(Map<String, String> nameValuePairs, String attr, long def, long max) {
        String value = nameValuePairs.get(attr);
        if (value == null) {
            return def;
        }
        try {
            return Math.min(max, Long.parseLong(value));
        }
        catch (NumberFormatException ignored) {
            return def;
        }
    }

    protected static final class Attr {
        static final String XML_SCHEMA = "xmlSchema";
        static final String URL = "url";
        static final String SIZE = "size";
        static final String CREATION_TIME = "creation_time";
        static final String VENDOR = "vendor";
        static final String NAME = "name";
        static final String FILE_TYPE = "fileType";

        private Attr() {
        }
    }
}

