/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.GnutellaSearchResult;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.ResultNameHolder;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.SharedSearchResult;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.ThirdPartySearchResult;
import com.limegroup.gnutella.gui.search.XMLSearchColumn;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameHolderImpl;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.Linkable;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.limewire.collection.NameValue;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableLine
extends AbstractDataLine<SearchResult>
implements Linkable {
    private final SearchTableColumns COLUMNS;
    private SearchResult RESULT;
    private List<SearchResult> _otherResults;
    private URN _sha1;
    private NamedMediaType _mediaType;
    private Set<IpPort> _alts;
    private boolean _savedFile;
    private boolean _incompleteFile;
    private boolean _downloading;
    private boolean _secure;
    private ResultSpeed _speed = null;
    private int _quality;
    private RemoteFileDesc _chatHost;
    private RemoteFileDesc _browseHost;
    private RemoteFileDesc _nonFirewalledHost;
    private LimeXMLDocument _doc;
    private EndpointHolder _location = null;
    private long _addedOn;
    private float _lastRating = -1.0f;
    private int _licenseState = -1;
    private String _licenseName = null;

    public TableLine(SearchTableColumns stc) {
        this.COLUMNS = stc;
    }

    @Override
    public void initialize(SearchResult sr) {
        super.initialize(sr);
        this.initilizeStart(sr);
        sr.initialize(this);
        this.initializeEnd();
    }

    private void initilizeStart(SearchResult sr) {
        this.RESULT = sr;
        this._doc = sr.getXMLDocument();
        this._sha1 = sr.getSHA1Urn();
        this._mediaType = this._doc != null ? NamedMediaType.getFromDescription(this._doc.getSchemaDescription()) : NamedMediaType.getFromExtension(this.getExtension());
        this._speed = new ResultSpeed(sr.getSpeed(), sr.isMeasuredSpeed());
        this._quality = sr.getQuality();
        this._secure = sr.getSecureStatus() == 2;
    }

    private void initializeEnd() {
        this.updateLicense();
        this.updateFileStatus();
    }

    @Override
    public boolean isLink() {
        if (this.RESULT instanceof Linkable) {
            return ((Linkable)((Object)this.RESULT)).isLink();
        }
        return this._doc != null && !"".equals(this._doc.getAction());
    }

    @Override
    public String getLinkUrl() {
        if (this.RESULT instanceof Linkable) {
            return ((Linkable)((Object)this.RESULT)).getLinkUrl();
        }
        return this._doc.getAction();
    }

    void addNewResult(SearchResult sr, MetadataModel mm) {
        ResultSpeed newSpeed;
        URN resultSHA1 = this.RESULT.getSHA1Urn();
        URN thisSHA1 = sr.getSHA1Urn();
        if (resultSHA1 == null ? !$assertionsDisabled && thisSHA1 != null : !$assertionsDisabled && !resultSHA1.equals(thisSHA1)) {
            throw new AssertionError();
        }
        if (this._otherResults == null) {
            this._otherResults = new LinkedList<SearchResult>();
        }
        this._otherResults.add(sr);
        this._lastRating = -1.0f;
        if (sr instanceof GnutellaSearchResult) {
            GnutellaSearchResult gsr = (GnutellaSearchResult)sr;
            RemoteFileDesc rfd = gsr.getRemoteFileDesc();
            Set<? extends IpPort> alts = gsr.getAlts();
            if (alts != null && !alts.isEmpty()) {
                if (this._alts == null) {
                    this._alts = new IpPortSet();
                }
                this._alts.addAll(alts);
                gsr.clearAlts();
                this._location.addHosts(alts);
            }
            this._location.addHost(rfd.getHost(), rfd.getPort());
        }
        if (this._speed.compareTo(newSpeed = new ResultSpeed(sr.getSpeed(), sr.isMeasuredSpeed())) < 0) {
            if (mm != null) {
                mm.updateProperty(Selector.PropertyType.SPEED.getKey(), this._speed, newSpeed, this);
            }
            this._speed = newSpeed;
        }
        this._quality = Math.max(sr.getQuality(), this._quality);
        this._secure |= sr.getSecureStatus() == 2;
        if (sr instanceof GnutellaSearchResult) {
            GnutellaSearchResult gsr = (GnutellaSearchResult)sr;
            RemoteFileDesc rfd = gsr.getRemoteFileDesc();
            if (rfd.getCreationTime() > 0L) {
                this._addedOn = Math.min(this._addedOn, rfd.getCreationTime());
            }
            if (this._chatHost == null && rfd.isChatEnabled()) {
                this._chatHost = rfd;
            }
            if (this._browseHost == null && rfd.isBrowseHostEnabled()) {
                this._browseHost = rfd;
            }
            if (this._nonFirewalledHost == null && !rfd.isFirewalled()) {
                this._nonFirewalledHost = rfd;
            }
        }
        if (sr.getCreationTime() > 0L) {
            this._addedOn = Math.min(this._addedOn, sr.getCreationTime());
        }
        this.updateXMLDocument(sr.getXMLDocument(), mm);
    }

    final boolean isThirdPartyResult() {
        return this.RESULT instanceof ThirdPartySearchResult;
    }

    private void updateXMLDocument(LimeXMLDocument newDoc, MetadataModel mm) {
        Set<String> newKeys;
        if (newDoc == null) {
            return;
        }
        if (this._doc == null) {
            this._doc = newDoc;
            this.updateLicense();
            if (mm != null) {
                this._mediaType = NamedMediaType.getFromDescription(this._doc.getSchemaDescription());
                mm.addNewDocument(this._doc, this);
            }
            return;
        }
        if (!this._doc.getSchemaURI().equals(newDoc.getSchemaURI())) {
            return;
        }
        Set<String> oldKeys = this._doc.getNameSet();
        if (oldKeys.containsAll(newKeys = newDoc.getNameSet())) {
            return;
        }
        newKeys = new HashSet<String>(newKeys);
        newKeys.removeAll(oldKeys);
        HashMap<String, String> newMap = new HashMap<String, String>(oldKeys.size() + newKeys.size());
        for (Map.Entry<String, String> entry : this._doc.getNameValueSet()) {
            newMap.put(entry.getKey(), entry.getValue());
        }
        LimeXMLSchema schema = this._doc.getSchema();
        for (SchemaFieldInfo sfi : schema.getCanonicalizedFields()) {
            String key = sfi.getCanonicalizedFieldName();
            if (!newKeys.contains(key)) continue;
            String value = newDoc.getValue(key);
            if (mm == null) continue;
            mm.addField(sfi, key, value, this);
        }
        this._doc = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(newMap.entrySet(), this._doc.getSchemaURI());
        this.updateLicense();
    }

    private void updateFileStatus() {
        if (this.RESULT instanceof SharedSearchResult) {
            SharedSearchResult ssr = (SharedSearchResult)this.RESULT;
            if (ssr.getFileDesc() instanceof IncompleteFileDesc) {
                this._incompleteFile = true;
            } else {
                this._savedFile = true;
            }
        } else {
            if (this._sha1 != null) {
                this._savedFile = GuiCoreMediator.getFileManager().isUrnShared(this._sha1);
                this._incompleteFile = GuiCoreMediator.getDownloadManager().isIncomplete(this._sha1);
            } else {
                this._savedFile = false;
                this._incompleteFile = false;
            }
            if (!this._savedFile) {
                this._savedFile = GuiCoreMediator.getSavedFileManager().isSaved(this._sha1, this.getFilename());
            }
        }
    }

    @Override
    public void update() {
        this.updateLicense();
        this._lastRating = -1.0f;
    }

    private void updateLicense() {
        if (this._doc != null && this._sha1 != null) {
            String licenseString = this._doc.getLicenseString();
            LicenseFactory factory = this._doc.getLicenseFactory();
            if (licenseString != null) {
                this._licenseState = factory.isVerifiedAndValid(this._sha1, licenseString) ? 2 : 0;
                this._licenseName = factory.getLicenseName(licenseString);
            }
        }
    }

    boolean isSecure() {
        return this._secure;
    }

    boolean isLicenseAvailable() {
        return this._licenseState != -1;
    }

    License getLicense() {
        if (this._doc != null && this._sha1 != null) {
            return this._doc.getLicense();
        }
        return null;
    }

    public URN getSHA1Urn() {
        return this._sha1;
    }

    ResultSpeed getSpeed() {
        return this._speed;
    }

    Date getAddedOn() {
        if (this._addedOn > 0L) {
            return new Date(this._addedOn);
        }
        return null;
    }

    int getQuality() {
        boolean downloading = this.RESULT.isDownloading();
        if (downloading != this._downloading) {
            this.updateFileStatus();
        }
        this._downloading = downloading;
        if (this._savedFile) {
            return 1002;
        }
        if (downloading) {
            return 1001;
        }
        if (this._incompleteFile) {
            return 1000;
        }
        if (this._secure) {
            return 999;
        }
        if (!this.isThirdPartyResult() && SearchSettings.ENABLE_SPAM_FILTER.getValue() && SpamFilter.isAboveSpamThreshold(this)) {
            return 1003;
        }
        return this._quality;
    }

    public NamedMediaType getNamedMediaType() {
        return this._mediaType;
    }

    LimeXMLDocument getXMLDocument() {
        return this._doc;
    }

    EndpointHolder getLocation() {
        return this._location;
    }

    List<SearchResult> getOtherResults() {
        if (this._otherResults == null) {
            return Collections.emptyList();
        }
        return this._otherResults;
    }

    Set<? extends IpPort> getAlts() {
        if (this._alts == null) {
            return Collections.emptySet();
        }
        return this._alts;
    }

    int getLocationCount() {
        return this._location == null ? 1 : this._location.numLocations();
    }

    String getLicenseName() {
        return this._licenseName;
    }

    boolean isChatEnabled() {
        return this._chatHost != null;
    }

    boolean isBrowseHostEnabled() {
        return this._browseHost != null;
    }

    boolean hasNonFirewalledRFD() {
        return this._nonFirewalledHost != null;
    }

    boolean isLaunchable() {
        return this._doc != null && this._doc.getAction() != null && !"".equals(this._doc.getAction());
    }

    String getFilenameNoExtension() {
        return this.RESULT.getFilenameNoExtension();
    }

    IconAndNameHolder getIconAndExtension() {
        String ext = this.getExtension();
        return new IconAndNameHolderImpl(this.getIcon(), ext);
    }

    Icon getIcon() {
        if (this.isThirdPartyResult()) {
            return new Icon(){
                private final Icon icon = GUIMediator.getThemeImage("external_link");

                public int getIconHeight() {
                    return this.icon.getIconHeight();
                }

                public int getIconWidth() {
                    return this.icon.getIconWidth();
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    this.icon.paintIcon(c, g, x, y);
                }

                public String toString() {
                    return null;
                }
            };
        }
        String ext = this.getExtension();
        return IconManager.instance().getIconForExtension(ext);
    }

    String getExtension() {
        return this.RESULT.getExtension();
    }

    public String getFilename() {
        return this.RESULT.getFileName();
    }

    public long getSize() {
        return this.RESULT.getSize();
    }

    String getVendor() {
        return this.RESULT.getVendor();
    }

    @Override
    public LimeTableColumn getColumn(int idx) {
        return this.COLUMNS.getColumn(idx);
    }

    @Override
    public int getColumnCount() {
        return SearchTableColumns.COLUMN_COUNT;
    }

    @Override
    public boolean isDynamic(int idx) {
        return false;
    }

    @Override
    public boolean isClippable(int idx) {
        switch (idx) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTypeAheadColumn() {
        return 4;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return new Integer(this.getQuality());
            }
            case 1: {
                int count = this.getLocationCount();
                if (count == 1) {
                    return null;
                }
                return new Integer(count);
            }
            case 3: {
                return this.getIcon();
            }
            case 4: {
                return new ResultNameHolder(this);
            }
            case 5: {
                return this.getExtension();
            }
            case 6: {
                return new SizeHolder(this.getSize());
            }
            case 7: {
                return this.getSpeed();
            }
            case 8: {
                return this.isChatEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return this.getLocation();
            }
            case 10: {
                return this.RESULT.getVendor();
            }
            case 11: {
                return this.getAddedOn();
            }
            case 2: {
                return new NameValue.ComparableByName<Integer>(this._licenseName, new Integer(this._licenseState));
            }
            case 12: {
                return new Float(this.getSpamRating());
            }
        }
        if (this._doc == null || index == -1) {
            return null;
        }
        XMLSearchColumn ltc = (XMLSearchColumn)this.getColumn(index);
        return new XMLValue(this._doc.getValue(ltc.getId()), ltc.getSchemaFieldInfo());
    }

    @Override
    public String[] getToolTipArray(int col) {
        if (col == 3 && OSUtils.isWindows()) {
            String str;
            Icon icon = this.getIcon();
            if (icon != null && (str = icon.toString()) != null) {
                return new String[]{icon.toString()};
            }
            return null;
        }
        if (col == 9 && this.getLocationCount() > 1) {
            StringBuilder sb = new StringBuilder(69);
            LinkedList<String> retList = new LinkedList<String>();
            Iterator<String> iter = this._location.getHosts().iterator();
            int i = 0;
            while (iter.hasNext()) {
                if (i == 3) {
                    i = 0;
                    retList.add(sb.toString());
                    sb = new StringBuilder(69);
                }
                sb.append(iter.next());
                if (iter.hasNext()) {
                    sb.append(", ");
                } else {
                    retList.add(sb.toString());
                }
                ++i;
            }
            return retList.toArray(new String[retList.size()]);
        }
        LinkedList<String> tips = new LinkedList<String>();
        if (this.isSecure()) {
            tips.add(I18n.tr("This is a secure result. No information in this result has been tampered."));
            tips.add("");
        }
        if (this.isLink()) {
            tips.add(this.getLinkUrl());
            tips.add("");
        }
        if (this._doc != null) {
            tips.addAll(XMLUtils.getDisplayList(this._doc));
        }
        if (!tips.isEmpty()) {
            tips.add(0, this.getFilenameNoExtension());
            return tips.toArray(new String[tips.size()]);
        }
        return null;
    }

    public final boolean isSameKindAs(TableLine line) {
        return this.getSearchResult().getClass().equals(line.getSearchResult().getClass());
    }

    String getHostname() {
        return this.RESULT.getHost();
    }

    RemoteFileDesc[] getAllRemoteFileDescs() {
        if (this.isThirdPartyResult()) {
            return new RemoteFileDesc[0];
        }
        GnutellaSearchResult sr = (GnutellaSearchResult)this.RESULT;
        int size = this.getOtherResults().size() + 1;
        RemoteFileDesc[] rfds = new RemoteFileDesc[size];
        rfds[0] = sr.getRemoteFileDesc();
        int j = 1;
        Iterator<SearchResult> i = this.getOtherResults().iterator();
        while (i.hasNext()) {
            rfds[j] = ((GnutellaSearchResult)i.next()).getRemoteFileDesc();
            ++j;
        }
        return rfds;
    }

    void doChat() {
        if (this._chatHost != null && this._chatHost.getHost() != null && this._chatHost.getPort() != -1) {
            GUIMediator.createChat(this._chatHost.getHost(), this._chatHost.getPort());
        }
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.RESULT instanceof GnutellaSearchResult ? ((GnutellaSearchResult)this.RESULT).getRemoteFileDesc() : null;
    }

    float getSpamRating() {
        if (this._lastRating == -1.0f) {
            this._lastRating = this.RESULT.getSpamRating();
            int num = 1;
            if (this._otherResults != null) {
                for (SearchResult r : this._otherResults) {
                    if (!(r instanceof GnutellaSearchResult)) continue;
                    ++num;
                    this._lastRating += ((GnutellaSearchResult)r).getRemoteFileDesc().getSpamRating();
                }
            }
            this._lastRating /= (float)num;
        }
        return this._lastRating;
    }

    RemoteFileDesc getBrowseHostEnabledRFD() {
        return this._browseHost;
    }

    RemoteFileDesc getNonFirewalledRFD() {
        return this._nonFirewalledHost;
    }

    RemoteFileDesc getChatEnabledRFD() {
        return this._chatHost;
    }

    public final SearchResult getSearchResult() {
        return this.RESULT;
    }

    public final Color getEvenRowColor() {
        return this.RESULT.getEvenRowColor();
    }

    public final Color getOddRowColor() {
        return this.RESULT.getOddRowColor();
    }

    public final void takeAction(TableLine line, GUID guid, File saveDir, String fileName, boolean saveAs, SearchInformation searchInfo) {
        this.RESULT.takeAction(line, guid, saveDir, fileName, saveAs, searchInfo);
    }

    final void setChatHost(RemoteFileDesc rfd) {
        this._chatHost = rfd;
    }

    final void setAddedOn(long creationTime) {
        this._addedOn = creationTime;
    }

    final void setNonFirewalledHost(RemoteFileDesc rfd) {
        this._nonFirewalledHost = rfd;
    }

    final void setBrowseHost(RemoteFileDesc rfd) {
        this._browseHost = rfd;
    }

    final void createEndpointHolder(String host, int port, boolean isReplyToMulticast) {
        this._location = new EndpointHolder(host, port, isReplyToMulticast);
    }

    final Set<IpPort> getAltIpPortSet() {
        if (this._alts == null) {
            this._alts = new IpPortSet();
        }
        return this._alts;
    }
}

