/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.sharing;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.StringArraySetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileTypeSharingPanelManager {
    private static final int MAX_EXT_LENGTH = 15;
    public static final String TITLE = I18nMarker.marktr("Sharing Extensions");
    public static final String LABEL = I18nMarker.marktr("Select the types of files on your computer that you wish to share with FrostWire.");
    public static final String URL = "http://www.frostwire.com/?id=faq#sea1";
    private Component parent = null;
    private JPanel mainContainer;
    private CheckBoxList<NamedMediaType> sidePanel;
    private CardLayout mediaLayout;
    private JPanel currentPanel;
    private CheckBoxList<String> customPanel;
    private Set<String> customUnchecked;
    private Map<NamedMediaType, CheckBoxList<String>> panels;
    private final ExtensionProvider extensionProvider = new ExtensionProvider();
    public static final String CUSTOM = "__Custom$";
    public static final String OTHER = "_Other$";
    public static final String CUSTOM_NAME = I18nMarker.marktr("My Extensions");
    public static final String OTHER_NAME = I18nMarker.marktr("Other");
    private static final NamedMediaType otherMedia = new NamedMediaType(new MediaType(OTHER_NAME, "_Other$", null), null);
    private static final NamedMediaType customMedia = new NamedMediaType(new MediaType("CUSTOM_NAME", "__Custom$", null), null);
    private JCheckBox disableSensitive;
    private boolean migrate;
    private Set<NamedMediaType> mediaKeys;
    private Set<NamedMediaType> mediaUnchecked;
    private NamedMediaType customKey = customMedia;
    private NamedMediaType currentKey;
    private String originalExtensions;

    public FileTypeSharingPanelManager(Component parent) {
        this();
        this.parent = parent;
    }

    public FileTypeSharingPanelManager() {
        this.customUnchecked = new HashSet<String>();
        this.mainContainer = new JPanel(new BorderLayout());
        this.mediaLayout = new CardLayout();
        this.currentPanel = new JPanel(this.mediaLayout);
    }

    private void switchPanel(NamedMediaType mediaKey) {
        this.currentKey = mediaKey;
        this.mediaLayout.show(this.currentPanel, mediaKey.toString());
        this.sidePanel.setItemSelected(mediaKey);
    }

    public void addCustomExt(String name) {
        Set<String> customExts = this.customPanel.getElements();
        customExts.add(name);
        this.customUnchecked = this.customPanel.getRawUncheckedElementsAsSet();
        this.customPanel.setElements(customExts, this.customUnchecked);
        this.switchPanel(this.customKey);
        this.sidePanel.setItemSelected(this.customKey);
    }

    private void revert() {
        NamedMediaType oldKey = this.currentKey;
        SharingSettings.EXTENSIONS_TO_SHARE.revertToDefault();
        SharingSettings.EXTENSIONS_LIST_CUSTOM.revertToDefault();
        SharingSettings.EXTENSIONS_LIST_UNSHARED.revertToDefault();
        SharingSettings.DISABLE_SENSITIVE.revertToDefault();
        this.initCore();
        this.buildUI();
        this.switchPanel(oldKey);
        this.sidePanel.setItemSelected(oldKey);
    }

    private void refreshSidePanel() {
        this.sidePanel.update();
    }

    private void setPanelEnabled(NamedMediaType mediaKey, boolean enabled) {
        this.panels.get(mediaKey).setEnabled(enabled);
    }

    public Container getContainer() {
        return this.mainContainer;
    }

    void initCore() {
        String[] selectedExtensions;
        this.customUnchecked.clear();
        HashSet<String> customExts = new HashSet<String>();
        Object[] totalExtensions = SharingSettings.getDefaultExtensions();
        this.migrate = SharingSettings.EXTENSIONS_MIGRATE.getValue();
        if (this.migrate) {
            selectedExtensions = StringArraySetting.decode(SharingSettings.EXTENSIONS_TO_SHARE.getValue().toLowerCase());
            for (int i = 0; i < selectedExtensions.length; ++i) {
                if (FileTypeSharingPanelManager.contains(totalExtensions, selectedExtensions[i])) continue;
                customExts.add(selectedExtensions[i]);
            }
        } else {
            int i;
            String[] custom = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_CUSTOM.getValue().toLowerCase());
            String[] unselected = StringArraySetting.decode(SharingSettings.EXTENSIONS_LIST_UNSHARED.getValue().toLowerCase());
            HashSet<Object> extSet = new HashSet<Object>();
            HashSet<Object> newTotalSet = new HashSet<Object>();
            for (i = 0; i < totalExtensions.length; ++i) {
                extSet.add(totalExtensions[i]);
                newTotalSet.add(totalExtensions[i]);
            }
            for (i = 0; i < custom.length; ++i) {
                if (custom[i].length() <= 0 || FileTypeSharingPanelManager.contains(totalExtensions, custom[i])) continue;
                customExts.add(custom[i]);
            }
            for (i = 0; i < unselected.length; ++i) {
                extSet.remove(unselected[i]);
                if (!customExts.contains(unselected[i])) continue;
                this.customUnchecked.add(unselected[i]);
            }
            totalExtensions = newTotalSet.toArray(new String[newTotalSet.size()]);
            selectedExtensions = new String[extSet.size()];
            selectedExtensions = extSet.toArray(selectedExtensions);
        }
        Map<NamedMediaType, List<String>> extensionsByType = FileTypeSharingPanelManager.createExtensionsMap(selectedExtensions, customExts);
        Map<NamedMediaType, List<String>> defaultsByType = FileTypeSharingPanelManager.createExtensionsMap((String[])totalExtensions, customExts);
        this.mediaKeys = new TreeSet<NamedMediaType>();
        Set<NamedMediaType> s = extensionsByType.keySet();
        if (s != null) {
            this.mediaKeys.addAll(s);
        }
        if ((s = defaultsByType.keySet()) != null) {
            this.mediaKeys.addAll(s);
        }
        this.panels = new LinkedHashMap<NamedMediaType, CheckBoxList<String>>();
        this.mediaUnchecked = new HashSet<NamedMediaType>();
        this.currentKey = null;
        PanelsCheckChangeListener refreshListener = new PanelsCheckChangeListener(this);
        for (NamedMediaType key : this.mediaKeys) {
            if (this.currentKey == null) {
                this.currentKey = key;
            }
            List<String> list = extensionsByType.get(key);
            List<String> defList = defaultsByType.get(key);
            TreeSet<String> total = new TreeSet<String>();
            TreeSet<String> notSelected = new TreeSet<String>();
            if (defList != null) {
                total.addAll(defList);
                notSelected.addAll(defList);
            }
            if (list != null) {
                total.addAll(list);
                notSelected.removeAll(list);
            }
            CheckBoxList<String> newPanel = new CheckBoxList<String>(total, notSelected, this.extensionProvider, 1);
            newPanel.setDisabledTooltip(I18n.tr("To allow selection enable sharing of sensitive types."));
            newPanel.setCheckChangeListener(refreshListener);
            if (((Object)total).equals(notSelected)) {
                newPanel.setEnabled(false);
                this.mediaUnchecked.add(key);
            }
            this.panels.put(key, newPanel);
        }
        this.insertNewCustomPanel(customExts);
        this.originalExtensions = this.getExtensions();
    }

    public void buildUI() {
        this.mainContainer.removeAll();
        this.currentPanel.removeAll();
        for (NamedMediaType key : this.mediaKeys) {
            this.currentPanel.add((Component)this.panels.get(key), key.toString());
        }
        this.sidePanel = new CheckBoxList<NamedMediaType>(this.mediaKeys, this.mediaUnchecked, new MediaProvider(), new MediaExtrasProvider(this.panels), 0);
        this.sidePanel.setPreferredSize(new Dimension(150, 0));
        this.sidePanel.setSelectionListener(new SideSelectListener(this));
        this.sidePanel.setCheckChangeListener(new CheckChangeListener(this));
        this.sidePanel.setItemSelected(this.currentKey);
        JSplitPane splitPane = new JSplitPane(1, this.sidePanel, this.currentPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(180);
        this.mainContainer.add((Component)splitPane, "Center");
        this.addBottomPanel();
        this.shareProtect(!SharingSettings.DISABLE_SENSITIVE.getValue());
        this.mainContainer.validate();
    }

    private void shareProtect(boolean state) {
        String[] disabled = SharingSettings.getDefaultDisabledExtensions();
        HashSet<String> totalDisabled = new HashSet<String>();
        for (String item : disabled) {
            totalDisabled.add(item);
        }
        for (CheckBoxList<String> panel : this.panels.values()) {
            panel.setItemsEnabled(totalDisabled, state);
        }
        this.refreshSidePanel();
    }

    private static Map<NamedMediaType, List<String>> createExtensionsMap(String[] extensions, Set<String> ignoreList) {
        if (extensions == null || extensions.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<NamedMediaType, List<String>> extensionsByType = new LinkedHashMap<NamedMediaType, List<String>>();
        for (String extension : extensions) {
            List typeExtension;
            NamedMediaType nm = NamedMediaType.getFromExtension(extension);
            if (nm == null) {
                nm = otherMedia;
            }
            if (!extensionsByType.containsKey(nm)) {
                extensionsByType.put(nm, new ArrayList(8));
            }
            if ((typeExtension = (List)extensionsByType.get(nm)).contains(extension) || ignoreList != null && ignoreList.contains(extension)) continue;
            typeExtension.add(extension);
        }
        return extensionsByType;
    }

    private String getExtensions() {
        HashSet<String> elements = new HashSet<String>();
        for (CheckBoxList<String> panel : this.panels.values()) {
            elements.addAll(panel.getCheckedElements());
        }
        String[] array = elements.toArray(new String[elements.size()]);
        return StringArraySetting.encode(array);
    }

    private String getUncheckedExtensions() {
        HashSet<String> elements = new HashSet<String>();
        for (CheckBoxList<String> panel : this.panels.values()) {
            elements.addAll(panel.getUncheckedElements());
        }
        String[] array = elements.toArray(new String[elements.size()]);
        return StringArraySetting.encode(array);
    }

    private static boolean contains(Object[] list, Object value) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExt(String text) {
        if (text == null) {
            return false;
        }
        String malformedMsg = I18n.tr("The extension name was not valid, could not add.");
        if (text.length() == 0 || text.length() > 15) {
            JOptionPane.showMessageDialog(this.parent, malformedMsg);
            return false;
        }
        if (FileTypeSharingPanelManager.contains(SharingSettings.getDefaultExtensions(), text)) {
            CheckBoxList<String> panel;
            NamedMediaType type = NamedMediaType.getFromExtension(text);
            if (type == null) {
                type = otherMedia;
            }
            if ((panel = this.panels.get(type)) == null) {
                JOptionPane.showMessageDialog(this.parent, malformedMsg);
                return false;
            }
            this.switchPanel(type);
            panel.setItemChecked(text);
            this.sidePanel.setItemSelected(type);
            return false;
        }
        if (this.customPanel.getElements().contains(text)) {
            CheckBoxList<String> panel = this.panels.get(this.customKey);
            if (panel == null) {
                JOptionPane.showMessageDialog(this.parent, malformedMsg);
                return false;
            }
            this.switchPanel(this.customKey);
            panel.setItemChecked(text);
            this.sidePanel.setItemSelected(this.customKey);
            return false;
        }
        return true;
    }

    private void addBottomPanel() {
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.disableSensitive = new JCheckBox(I18n.tr("Do Not Share Sensitive File Types"));
        this.disableSensitive.setToolTipText(I18n.tr("This stops FrostWire from sharing certain files that may contain sensitive information."));
        this.disableSensitive.setSelected(SharingSettings.DISABLE_SENSITIVE.getValue());
        JPanel buffer = new JPanel(new BorderLayout());
        buffer.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.disableSensitive.setBorder(null);
        buffer.add(this.disableSensitive);
        bottomPanel.add((Component)new JButton(new RestoreAction()), "West");
        bottomPanel.add((Component)buffer, "South");
        bottomPanel.add((Component)new JButton(new AddExtAction()), "East");
        this.disableSensitive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileTypeSharingPanelManager.this.shareProtect(!((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.mainContainer.add((Component)bottomPanel, "South");
    }

    private void insertNewCustomPanel(Set<String> customExts) {
        this.customPanel = new CheckBoxList<String>(customExts, this.customUnchecked, this.extensionProvider, 1);
        this.customPanel.setRemovable(true);
        this.customPanel.setCheckChangeListener(new PanelsCheckChangeListener(this));
        this.currentPanel.add(this.customPanel, this.customKey.toString());
        this.mediaKeys.add(this.customKey);
        this.panels.put(this.customKey, this.customPanel);
    }

    public void initOptions() {
        this.initCore();
        this.buildUI();
    }

    public boolean applyOptions() {
        String newList = this.getExtensions();
        SharingSettings.EXTENSIONS_TO_SHARE.setValue(newList);
        GuiCoreMediator.getFileManager().loadSettings();
        SharingSettings.DISABLE_SENSITIVE.setValue(this.disableSensitive == null || this.disableSensitive.isSelected());
        String[] customArray = new String[this.customPanel.getElements().size()];
        customArray = this.customPanel.getElements().toArray(customArray);
        SharingSettings.EXTENSIONS_MIGRATE.setValue(false);
        SharingSettings.EXTENSIONS_LIST_UNSHARED.setValue(this.getUncheckedExtensions());
        SharingSettings.EXTENSIONS_LIST_CUSTOM.setValue(StringArraySetting.encode(customArray));
        return false;
    }

    public boolean isDirty() {
        return !this.originalExtensions.equals(this.getExtensions()) || !this.disableSensitive.isSelected() == SharingSettings.DISABLE_SENSITIVE.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MediaExtrasProvider
    implements CheckBoxList.ExtrasProvider<NamedMediaType> {
        Map<NamedMediaType, CheckBoxList<String>> panels;

        public MediaExtrasProvider(Map<NamedMediaType, CheckBoxList<String>> panels) {
            this.panels = panels;
        }

        @Override
        public boolean isSeparated(NamedMediaType obj) {
            return customMedia.equals(obj);
        }

        @Override
        public String getComment(NamedMediaType obj) {
            CheckBoxList<String> panel = this.panels.get(obj);
            if (panel == null) {
                return "(0)";
            }
            return "(" + panel.getCheckedElements().size() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MediaProvider
    implements CheckBoxList.TextProvider<NamedMediaType> {
        private MediaProvider() {
        }

        @Override
        public String getText(NamedMediaType obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            if (FileTypeSharingPanelManager.CUSTOM.equals(obj.getName())) {
                return CUSTOM_NAME;
            }
            if (FileTypeSharingPanelManager.OTHER.equals(obj.getName())) {
                return OTHER_NAME;
            }
            return obj.getName();
        }

        @Override
        public String getToolTipText(NamedMediaType obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            if (obj.getName() == null) {
                return null;
            }
            if (FileTypeSharingPanelManager.CUSTOM.equals(obj.getName())) {
                return I18n.tr("File types you added to share.");
            }
            if (FileTypeSharingPanelManager.OTHER.equals(obj.getName())) {
                return I18n.tr("Other types of files.");
            }
            return obj.getMediaType().getDescriptionKey();
        }

        @Override
        public Icon getIcon(NamedMediaType obj) {
            ImageIcon icon;
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            if (FileTypeSharingPanelManager.CUSTOM.equals(obj.getName())) {
                ImageIcon icon2 = GUIMediator.getThemeImage("custom");
                if (icon2 != null) {
                    return icon2;
                }
            } else if (FileTypeSharingPanelManager.OTHER.equals(obj.getName()) && (icon = GUIMediator.getThemeImage("lime")) != null) {
                return icon;
            }
            return obj.getIcon();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionProvider
    implements CheckBoxList.TextProvider<String> {
        private Set<String> mediaNames = new HashSet<String>();

        public ExtensionProvider() {
            for (NamedMediaType mt : NamedMediaType.getAllNamedMediaTypes()) {
                this.mediaNames.add(mt.getName());
            }
        }

        @Override
        public String getText(String obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            return obj;
        }

        @Override
        public String getToolTipText(String obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            Icon icon = IconManager.instance().getIconForExtension(obj);
            if (icon == null) {
                return null;
            }
            if (icon.toString().indexOf("@") > -1) {
                return null;
            }
            if (this.mediaNames.contains(icon.toString())) {
                return null;
            }
            return icon.toString();
        }

        @Override
        public Icon getIcon(String obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            Icon icon = IconManager.instance().getIconForExtension(obj);
            return icon != null ? icon : new GUIUtils.EmptyIcon(obj, 16, 16);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PanelsCheckChangeListener
    implements CheckBoxList.CheckBoxListCheckChangeListener<NamedMediaType> {
        private FileTypeSharingPanelManager parent;

        public PanelsCheckChangeListener(FileTypeSharingPanelManager parent) {
            this.parent = parent;
        }

        @Override
        public void valueChanged(CheckBoxList.CheckBoxListCheckChangeEvent<NamedMediaType> e) {
            this.parent.refreshSidePanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckChangeListener
    implements CheckBoxList.CheckBoxListCheckChangeListener<NamedMediaType> {
        private FileTypeSharingPanelManager parent;

        public CheckChangeListener(FileTypeSharingPanelManager parent) {
            this.parent = parent;
        }

        @Override
        public void valueChanged(CheckBoxList.CheckBoxListCheckChangeEvent<NamedMediaType> e) {
            this.parent.setPanelEnabled(e.getSelected(), e.getChecked());
            this.parent.refreshSidePanel();
        }
    }

    private static class SideSelectListener
    implements CheckBoxList.CheckBoxListSelectionListener {
        private FileTypeSharingPanelManager parent;

        public SideSelectListener(FileTypeSharingPanelManager parent) {
            this.parent = parent;
        }

        public void valueChanged(CheckBoxList.CheckBoxListSelectionEvent e) {
            this.parent.switchPanel((NamedMediaType)e.getSelected());
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            this.putValue("Name", I18n.tr("Restore Defaults"));
            this.putValue("ShortDescription", I18n.tr("Share the Default File Extensions"));
        }

        public void actionPerformed(ActionEvent e) {
            int answer = JOptionPane.showConfirmDialog(FileTypeSharingPanelManager.this.parent, new Object[]{new MultiLineLabel(I18n.tr("This options clears any extension sharing changes you made and sets FrostWire's extension sharing preferences to the original preferences. Do you wish to continue?"), 300)}, I18n.tr("Extension Sharing Settings"), 0);
            if (answer == 0) {
                FileTypeSharingPanelManager.this.revert();
            }
        }
    }

    private class AddExtAction
    extends AbstractAction {
        public AddExtAction() {
            this.putValue("Name", I18n.tr("Add New Extension"));
            this.putValue("ShortDescription", I18n.tr("Add a New Extension to My Extensions"));
        }

        public void actionPerformed(ActionEvent e) {
            String text = JOptionPane.showInputDialog(FileTypeSharingPanelManager.this.parent, I18n.tr("Enter the extension pattern:"), I18n.tr("Extension Sharing Settings"), -1);
            if (text == null) {
                return;
            }
            text = text.toLowerCase();
            if (FileTypeSharingPanelManager.this.checkExt(text)) {
                FileTypeSharingPanelManager.this.addCustomExt(text);
            }
        }
    }
}

