/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.sharing;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.library.SharingUtils;
import java.io.File;

public class ShareManager {
    public static boolean checkAndWarnNewSharedFolder(File folder) {
        if (folder == null) {
            return false;
        }
        if (!folder.isDirectory() || !folder.canRead()) {
            GUIMediator.showError(I18n.tr("<html><table width=400>You selected: <i>{0}</i><br>FrostWire cannot share this folder because it is either not a folder or cannot be read.<br><br>Please select another folder to share.</table></html>", folder));
            return false;
        }
        if (!GuiCoreMediator.getFileManager().isFolderShareable(folder, false)) {
            GUIMediator.showError(I18n.tr("<html><table width=400>You selected: <i>{0}</i><br>FrostWire cannot share this folder for security reasons.<br><br>Please select another folder to share.</table></html>", folder));
            return false;
        }
        return !SharingUtils.isSensitiveDirectory(folder) || ShareManager.warnAboutSensitiveDirectory(folder);
    }

    public static boolean warnAboutSensitiveDirectory(File folder) {
        String dirName = GUIUtils.convertToNonBreakingSpaces(0, folder.getAbsolutePath());
        DialogOption retval = GUIMediator.showYesNoMessage(I18n.tr("<html><table width=400>The folder <i>{0}</i><br>is likely to contain sensitive or personal information.<br><br>FrostWire recommends that you <b>DO NOT</b> share this folder.<br><br>Are you sure you want to share it?</table></html>", dirName), DialogOption.NO);
        if (retval == DialogOption.YES) {
            GuiCoreMediator.getFileManager().validateSensitiveFile(folder);
            return true;
        }
        GuiCoreMediator.getFileManager().invalidateSensitiveFile(folder);
        return false;
    }
}

