/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.shell.ShellAssociation;
import java.io.IOException;

abstract class WindowsAssociation
implements ShellAssociation {
    protected final String executable;

    protected WindowsAssociation(String executable) {
        this.executable = executable;
    }

    public boolean isAvailable() {
        try {
            return "".equals(this.get());
        }
        catch (IOException readFailed) {
            return false;
        }
    }

    public boolean isRegistered() {
        try {
            return this.executable.equals(this.get());
        }
        catch (IOException readFailed) {
            return false;
        }
    }

    protected abstract String get() throws IOException;

    protected static String parsePath(String value) {
        int end;
        int begin;
        if ("".equals(value)) {
            return "";
        }
        if (value.startsWith("\"")) {
            begin = 1;
            end = value.indexOf("\"", begin);
        } else {
            begin = 0;
            end = value.indexOf(" ");
        }
        if (end == -1) {
            return value;
        }
        return value.substring(begin, end);
    }
}

