/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.shell.WindowsAssociation;
import java.io.IOException;
import org.limewire.util.SystemUtils;

public class WindowsExtentionShellAssociation
extends WindowsAssociation {
    private static final String HKCU = "HKEY_CURRENT_USER";
    private static final String MAIN_REGISTRY_PATH = "Software\\Classes\\";
    private final String extention;
    private final String extention_name;
    private final String content_type;
    private final String description;
    private final String name;

    public WindowsExtentionShellAssociation(String executable, String extention, String name, String content_type, String description) {
        super(executable);
        this.extention = "Software\\Classes\\." + extention;
        this.extention_name = "." + extention;
        this.name = name;
        this.content_type = content_type;
        this.description = description;
    }

    protected String get() throws IOException {
        String command = SystemUtils.registryReadText(HKCU, this.extention + "\\shell\\open\\command", "");
        return WindowsExtentionShellAssociation.parsePath(command);
    }

    public void register() {
        SystemUtils.registryWriteText(HKCU, this.extention, "", this.name);
        SystemUtils.registryWriteText(HKCU, this.extention, "Content type", this.content_type);
        SystemUtils.registryWriteText(HKCU, "Software\\Classes\\Mime\\Database\\Content Type", "Extension", this.content_type);
        SystemUtils.registryWriteText(HKCU, "Software\\Classes\\Mime\\Database\\Content Type\\" + this.content_type, "Extension", this.extention_name);
        SystemUtils.registryWriteText(HKCU, MAIN_REGISTRY_PATH + this.name, "", this.description);
        SystemUtils.registryWriteText(HKCU, MAIN_REGISTRY_PATH + this.name, "Generated By", "Generated By FrostWire LLC");
        SystemUtils.registryWriteText(HKCU, MAIN_REGISTRY_PATH + this.name + "\\DefaultIcon", "", this.executable + ",0");
        SystemUtils.registryWriteText(HKCU, MAIN_REGISTRY_PATH + this.name + "\\shell\\open\\command", "", "\"" + this.executable + "\" \"%1\"");
    }

    public void unregister() {
        SystemUtils.registryWriteText(HKCU, this.extention, "", "");
        SystemUtils.registryDelete(HKCU, this.extention);
        if (!this.name.equals("")) {
            SystemUtils.registryDelete(HKCU, MAIN_REGISTRY_PATH + this.name);
        }
    }
}

