/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.swtbrowser;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.swtbrowser.SWTBrowser;
import com.limegroup.gnutella.settings.SWTBrowserSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.limewire.concurrent.ManagedThread;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

public final class SWTBrowserPanel
extends JPanel
implements ComponentListener {
    private static final Log LOG = LogFactory.getLog(SWTBrowserPanel.class);
    private volatile SWTBrowser browser;
    private final AtomicBoolean isBrowserCreated = new AtomicBoolean(false);
    private Canvas swingCanvas;
    private final JPanel swingNavigationPanel;
    private final JPanel swingProgressPanel;
    private final JTextField swingAddressField = new JTextField(60);
    private final JLabel swingStatusText = new JLabel(I18n.tr("Idle"));
    private final JProgressBar swingProgressBar = new JProgressBar(0);
    private boolean busy;
    private Action swingBackAction;
    private Action swingForwardAction;
    private final EmptyBorder emptyBorder = new EmptyBorder(5, 5, 0, 5);
    static final Color LWS_BACKGROUND_COLOR = new Color(26, 58, 78, 255);
    private JScrollPane scrollPane;
    private JPanel errorPanel;

    public SWTBrowserPanel() {
        super(new BorderLayout());
        int SPACE = 5;
        this.swingStatusText.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.swingNavigationPanel = this.makeNavigationPanel();
        this.swingProgressPanel = this.makeProgressPanel();
        this.add((Component)this.swingNavigationPanel, "North");
        this.add((Component)this.swingProgressPanel, "South");
        this.setBackground(LWS_BACKGROUND_COLOR);
        this.addComponentListener(this);
    }

    public void createBrowser() {
        if (this.isBrowserCreated.getAndSet(true)) {
            return;
        }
        this.internalCreateBrowser();
    }

    private String munge(String location) {
        int idx;
        String guid = new GUID(GuiCoreMediator.getApplicationServices().getMyGUID()).toHexString();
        if (location != null && (idx = location.indexOf("guid=" + guid)) != -1 && idx != 0) {
            location = location.substring(0, idx - 1);
        }
        return location;
    }

    private void internalCreateBrowser() {
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        if (this.errorPanel != null) {
            this.remove(this.errorPanel);
        }
        this.swingCanvas = new Canvas();
        this.swingCanvas.setBackground(LWS_BACKGROUND_COLOR);
        this.scrollPane = new JScrollPane(this.swingCanvas, 21, 31);
        this.add((Component)this.scrollPane, "Center");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating browser");
        }
        new ManagedThread(new Runnable(){

            public void run() {
                try {
                    SWTBrowserPanel.this.browser = new SWTBrowser(SWTBrowserPanel.this.swingCanvas, SWTBrowserPanel.this.getWidth(), SWTBrowserPanel.this.getHeight(), new LocationListener(){

                        public void changed(LocationEvent e) {
                            if (e.top) {
                                final String location = SWTBrowserPanel.this.munge(e.location);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        SWTBrowserPanel.this.swingAddressField.setText(location);
                                    }
                                });
                            }
                        }

                        public void changing(LocationEvent e) {
                        }
                    });
                    SWTBrowserPanel.this.browser.addProgressListener(new ProgressListener(){

                        public void changed(ProgressEvent event) {
                            final int total = event.total;
                            if (total == 0) {
                                return;
                            }
                            final int current = event.current;
                            final int ratio = current * 100 / total;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    SWTBrowserPanel.this.swingProgressBar.setValue(ratio);
                                    SWTBrowserPanel.this.busy = current != total;
                                    if (!SWTBrowserPanel.this.busy) {
                                        SWTBrowserPanel.this.swingCanvas.repaint();
                                    }
                                }
                            });
                        }

                        public void completed(ProgressEvent event) {
                            final boolean isBackEnabled = SWTBrowserPanel.this.browser.isBackEnabled();
                            final boolean isForwardEnabled = SWTBrowserPanel.this.browser.isForwardEnabled();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    SWTBrowserPanel.this.swingBackAction.setEnabled(isBackEnabled);
                                    SWTBrowserPanel.this.swingForwardAction.setEnabled(isForwardEnabled);
                                    SWTBrowserPanel.this.swingProgressBar.setValue(0);
                                    SWTBrowserPanel.this.swingStatusText.setText(I18n.tr("Idle"));
                                    SWTBrowserPanel.this.busy = false;
                                    SWTBrowserPanel.this.swingCanvas.repaint();
                                }
                            });
                        }
                    });
                    SWTBrowserPanel.this.browser.addStatusTextListener(new StatusTextListener(){

                        public void changed(StatusTextEvent event) {
                            final String text = event.text;
                            if (text != null && !text.equals("")) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        SWTBrowserPanel.this.swingStatusText.setText(text);
                                    }
                                });
                            }
                        }
                    });
                    SWTBrowserPanel.this.browser.start(SWTBrowserPanel.this.getHomeURL());
                }
                catch (Throwable t) {
                    LOG.error(t);
                    SWTBrowserPanel.this.displayErrorInBrowser();
                }
            }
        }, "swtbrowser-thread").start();
    }

    private void displayErrorInBrowser() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SWTBrowserPanel.this.remove(SWTBrowserPanel.this.scrollPane);
                SWTBrowserPanel.this.add((Component)SWTBrowserPanel.this.getErrorPanel(), "Center");
                SWTBrowserPanel.this.repaint();
            }
        });
    }

    private JPanel getErrorPanel() {
        if (this.errorPanel == null) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            this.errorPanel = new JPanel(new GridBagLayout());
            this.errorPanel.setBackground(LWS_BACKGROUND_COLOR);
            JLabel errorLabel = new JLabel(I18n.tr("Sorry, the browser could not be loaded."));
            errorLabel.setForeground(Color.red);
            errorLabel.setFont(errorLabel.getFont().deriveFont(24.0f));
            this.errorPanel.add((Component)errorLabel, c);
        }
        return this.errorPanel;
    }

    public void destroyBrowser() {
        this.isBrowserCreated.getAndSet(false);
    }

    private JPanel makeNavigationPanel() {
        JPanel res = new JPanel();
        res.setLayout(new BoxLayout(res, 0));
        ButtonRow buttonRow = this.makeBrowserButtons();
        res.add(buttonRow);
        res.add(this.swingAddressField);
        AbstractAction goAction = new AbstractAction(I18n.tr("Go")){

            public void actionPerformed(ActionEvent e) {
                String url = SWTBrowserPanel.this.swingAddressField.getText();
                if (url == null || SWTBrowserPanel.this.browser == null) {
                    return;
                }
                SWTBrowserPanel.this.browser.setUrl(SWTBrowserPanel.makeNicerURL(url.trim()));
            }
        };
        this.swingAddressField.addActionListener(goAction);
        final JButton go = new JButton(goAction);
        res.add(go);
        final BooleanSetting setting = SWTBrowserSettings.BROWSER_SHOW_ADDRESS;
        this.swingAddressField.setVisible(setting.getValue());
        go.setVisible(setting.getValue());
        setting.addSettingListener(new SettingListener(){

            public void settingChanged(SettingEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SWTBrowserPanel.this.swingAddressField.setVisible(setting.getValue());
                        go.setVisible(setting.getValue());
                    }
                });
            }
        });
        return res;
    }

    private JPanel makeProgressPanel() {
        JPanel res = new JPanel(new BorderLayout());
        res.add((Component)this.swingStatusText, "West");
        res.add((Component)this.swingProgressBar, "East");
        return res;
    }

    private static String makeNicerURL(String url) {
        if (url == null) {
            return "";
        }
        if (url.indexOf("://") == -1) {
            url = "http://" + url;
        }
        return url;
    }

    private ButtonRow makeBrowserButtons() {
        Action[] as = new Action[]{new BrowserButtonAction(I18n.tr("Back"), "SWT_BROWSER_BACK"){

            public void actionPerformed(ActionEvent e) {
                SWTBrowserPanel.this.browserBack();
            }
        }, new BrowserButtonAction(I18n.tr("Stop"), "SWT_BROWSER_STOP"){

            public void actionPerformed(ActionEvent e) {
                SWTBrowserPanel.this.browserStop();
            }
        }, new BrowserButtonAction(I18n.tr("Store"), "SWT_BROWSER_HOME"){

            public void actionPerformed(ActionEvent e) {
                SWTBrowserPanel.this.browserHome();
            }
        }, new BrowserButtonAction(I18n.tr("Forward"), "SWT_BROWSER_NEXT"){

            public void actionPerformed(ActionEvent e) {
                SWTBrowserPanel.this.browserForward();
            }
        }};
        ButtonRow res = new ButtonRow(as, 0, 14);
        this.swingBackAction = as[0];
        this.swingForwardAction = as[as.length - 1];
        return res;
    }

    protected final void browserForward() {
        if (this.browser != null) {
            this.browser.forward();
        }
    }

    protected final void browserBack() {
        if (this.browser != null) {
            this.browser.back();
        }
    }

    protected final void browserStop() {
        if (this.browser != null) {
            this.browser.stop();
        }
    }

    private void browserHome() {
        this.setURL(this.getHomeURL());
    }

    private void setURL(String u) {
        if (this.browser != null) {
            this.browser.setUrl(u);
        }
    }

    private String getHomeURL() {
        String url = SWTBrowserSettings.BROWSER_HOME_URL.getValue();
        byte[] guid = GuiCoreMediator.getApplicationServices().getMyGUID();
        return LimeWireUtils.addLWInfoToUrl(url, guid);
    }

    public void componentResized(ComponentEvent e) {
        if (this.swingCanvas != null) {
            Insets insets = this.emptyBorder.getBorderInsets();
            this.swingCanvas.setSize(this.getWidth() - insets.left - insets.right, this.getHeight() - 2 * this.swingProgressPanel.getPreferredSize().height - insets.top - insets.bottom - 5);
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    private static abstract class BrowserButtonAction
    extends AbstractAction {
        BrowserButtonAction(String shortDescriptionKey, String iconName) {
            this.putValue("Name", "");
            this.putValue("ShortDescription", I18n.tr(shortDescriptionKey));
            this.putValue("LimeIconName", iconName);
        }
    }
}

