/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ColorRenderer
extends JComponent
implements TableCellRenderer,
ThemeObserver {
    private Map<TableCellRenderer, TableCellRenderer> otherRenderers = new HashMap<TableCellRenderer, TableCellRenderer>();

    public ColorRenderer() {
        ThemeMediator.addThemeObserver(this);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        Class clazz;
        Object val;
        Color clr;
        ColoredCell cc = (ColoredCell)value;
        if (cc != null) {
            clr = cc.getColor();
            val = cc.getValue();
            clazz = cc.getCellClass();
        } else {
            clr = null;
            val = "";
            clazz = String.class;
        }
        TableCellRenderer tcr = table.getDefaultRenderer(clazz);
        tcr = this.getCachedOrNewRenderer(tcr);
        Component renderer = tcr.getTableCellRendererComponent(table, val, isSel, hasFocus, row, column);
        if (!isSel && !hasFocus) {
            renderer.setForeground(clr);
        }
        return renderer;
    }

    public void updateTheme() {
        for (TableCellRenderer o : this.otherRenderers.values()) {
            if (!(o instanceof ThemeObserver)) continue;
            ((ThemeObserver)((Object)o)).updateTheme();
        }
    }

    public void updateUI() {
        for (TableCellRenderer o : this.otherRenderers.values()) {
            if (!(o instanceof JComponent)) continue;
            ((JComponent)((Object)o)).updateUI();
        }
    }

    private TableCellRenderer getCachedOrNewRenderer(TableCellRenderer tcr) {
        TableCellRenderer renderer = this.otherRenderers.get(tcr);
        if (renderer == null) {
            Class<?> rendererClass = tcr.getClass();
            try {
                renderer = (TableCellRenderer)rendererClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(e);
            }
            this.otherRenderers.put(tcr, renderer);
        }
        return renderer;
    }
}

