/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.TablesHandler;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.SettingsFactory;

public class TableSettings {
    protected static final SettingsFactory FACTORY = TablesHandler.instance().getFactory();
    private static final BooleanSetting OLD_STRIPE = LimeProps.instance().getFactory().createBooleanSetting("ROW_STRIPE_ENABLED", true);
    private static final String STRIPE = "_ROWSTRIPE";
    private static final String SORT = "_SORT";
    private static final String TOOLTIP = " _TOOLTIP";
    private static final String MIGRATED = "_MIGRATED";
    public BooleanSetting ROWSTRIPE;
    public BooleanSetting REAL_TIME_SORT;
    public BooleanSetting DISPLAY_TOOLTIPS;
    private BooleanSetting ROWSTRIPE_MIGRATED;
    private final String ID;

    public TableSettings(String id) {
        this.ID = id;
        this.ROWSTRIPE = FACTORY.createBooleanSetting(id + STRIPE, this.getDefaultRowStripe());
        this.REAL_TIME_SORT = FACTORY.createBooleanSetting(id + SORT, this.getDefaultSorting());
        this.DISPLAY_TOOLTIPS = FACTORY.createBooleanSetting(id + TOOLTIP, this.getDefaultTooltips());
        this.ROWSTRIPE_MIGRATED = FACTORY.createBooleanSetting(id + MIGRATED, false);
        if (!this.ROWSTRIPE_MIGRATED.getValue()) {
            this.ROWSTRIPE.setValue(OLD_STRIPE.getValue());
            this.ROWSTRIPE_MIGRATED.setValue(true);
        }
    }

    public String getID() {
        return this.ID;
    }

    protected boolean getDefaultRowStripe() {
        return true;
    }

    protected boolean getDefaultSorting() {
        return true;
    }

    protected boolean getDefaultTooltips() {
        return true;
    }

    public void revertToDefault() {
        this.ROWSTRIPE.revertToDefault();
        this.REAL_TIME_SORT.revertToDefault();
        this.DISPLAY_TOOLTIPS.revertToDefault();
    }

    public boolean isDefault() {
        return this.ROWSTRIPE.isDefault() && this.REAL_TIME_SORT.isDefault() && this.DISPLAY_TOOLTIPS.isDefault();
    }
}

