/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.trees;

import com.limegroup.gnutella.gui.trees.AbstractTreeModel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

public class FileTreeModel
extends AbstractTreeModel {
    private List<File> subRoots;
    private Hashtable<String, List<File>> subChildren = new Hashtable();
    private File cachedDir;
    private boolean cacheSorted;
    private File[] cache;
    private Comparator<File> comparator = DEFAULT_COMPARATOR;
    private FileFilter filter = new DefaultFilter();
    private boolean sort = true;
    public static final Comparator<File> DEFAULT_COMPARATOR = new FileComparator();

    public FileTreeModel(String root, File ... roots) {
        super(root);
        if (roots != null) {
            this.subRoots = new ArrayList<File>(roots.length);
            for (int i = 0; i < roots.length; ++i) {
                this.addSubRoot(roots[i]);
            }
        } else {
            this.subRoots = new ArrayList<File>();
        }
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public int getChildCount(Object node) {
        if (node instanceof File && ((File)node).canRead()) {
            return this.getSubDirs((File)node, false).length;
        }
        if (this.root.getClass().isInstance(node)) {
            if (node.equals(this.root)) {
                return this.subRoots.size();
            }
            return this.subChildren.get(node).size();
        }
        return 0;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof File) {
            File[] children = this.getSubDirs((File)parent, this.sort);
            if (index >= children.length) {
                return null;
            }
            return children[index];
        }
        if (this.root.getClass().isInstance(parent)) {
            if (parent.equals(this.root) && index < this.subRoots.size()) {
                return this.subRoots.get(index);
            }
            List<File> v = this.subChildren.get(parent);
            return index < v.size() ? v.get(index) : null;
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof File) {
            File[] children = this.getSubDirs((File)parent, this.sort);
            if (children == null) {
                return -1;
            }
            for (int i = 0; i < children.length; ++i) {
                if (children[i] != child) continue;
                return i;
            }
        } else if (this.root.getClass().isInstance(parent)) {
            if (parent.equals(this.root)) {
                return this.subRoots.indexOf(child);
            }
            return this.subChildren.get(parent).indexOf(child);
        }
        return -1;
    }

    private File[] getSubDirs(File f, boolean doSort) {
        if (f == this.cachedDir && this.cacheSorted == doSort) {
            return this.cache;
        }
        File[] children = f.listFiles(this.filter);
        if (children == null) {
            this.cache = new File[0];
        } else {
            this.cache = children;
            if (doSort) {
                Arrays.sort(this.cache, this.comparator);
            }
        }
        this.cachedDir = f;
        this.cacheSorted = doSort;
        return this.cache;
    }

    public void addSubRoot(File f) {
        if (this.subRoots.contains(f)) {
            return;
        }
        this.subRoots.add(f);
        Object[] path = new Object[]{this.root};
        int[] indices = new int[]{this.subRoots.size() - 1};
        Object[] children = new Object[]{f};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, path, indices, children));
    }

    public boolean isSubRoot(File file) {
        return this.subRoots.contains(file);
    }

    public void removeSubRoot(File f) {
        int index = this.subRoots.indexOf(f);
        if (index != -1) {
            this.subRoots.remove(index);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.root}, new int[]{index}, new Object[]{f}));
        }
    }

    public void removeSubRoots() {
        for (int i = 0; i < this.subRoots.size(); ++i) {
            this.subChildren.remove(this.subRoots.get(i));
        }
        this.subRoots.clear();
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
    }

    public void valueForPathChanged(TreePath path, Object value) {
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, path));
    }

    public void removeChildrenOfSubRoot(String s) {
        if (!this.subRoots.contains(s)) {
            return;
        }
        this.subChildren.get(s).clear();
        Object[] path = new Object[]{this.root, s};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
    }

    public void setFileFilter(FileFilter filter) {
        this.filter = filter;
    }

    public FileFilter getFileFilter() {
        return this.filter;
    }

    public void setSortListedFiles(boolean sort) {
        if (this.sort != sort) {
            this.sort = sort;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
    }

    public boolean getSortListedFiles() {
        return this.sort;
    }

    private class DefaultFilter
    implements FileFilter {
        private DefaultFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() && !file.isHidden();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            return o1.getAbsolutePath().compareToIgnoreCase(o2.getAbsolutePath());
        }
    }
}

