/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.util;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.QuestionsHandler;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.Cursor;
import java.io.File;

public class GUILauncher {
    public static void launch(LaunchableProvider[] providers) {
        boolean audioLaunched = false;
        GUIMediator.instance().setFrameCursor(Cursor.getPredefinedCursor(3));
        for (LaunchableProvider provider : providers) {
            final Downloader dl = provider.getDownloader();
            if (dl == null) {
                File file = provider.getFile();
                if (file == null) continue;
                audioLaunched = GUIUtils.launchOrEnqueueFile(file, audioLaunched);
                continue;
            }
            if (dl.getState() == Downloader.DownloadStatus.INVALID) {
                GUIMediator.openURL("http://www.frostwire.com/?id=faq#Downloading");
                continue;
            }
            File fragment = (File)Worker.post(new Job(){

                public Object run() {
                    return dl.getDownloadFragment();
                }
            });
            if (fragment != null && dl.getState() == Downloader.DownloadStatus.COMPLETE) {
                audioLaunched = GUIUtils.launchOrEnqueueFile(fragment, false);
                continue;
            }
            if (fragment != null) {
                audioLaunched = GUIUtils.launchOneTimeFile(fragment);
                continue;
            }
            GUIMediator.instance().setFrameCursor(Cursor.getDefaultCursor());
            GUIMediator.showMessage(I18n.tr("There is nothing to preview for file {0}.", dl.getSaveFile().getName()), QuestionsHandler.NO_PREVIEW_REPORT);
            GUIMediator.instance().setFrameCursor(Cursor.getPredefinedCursor(3));
        }
        GUIMediator.instance().setFrameCursor(Cursor.getDefaultCursor());
    }

    public static interface LaunchableProvider {
        public Downloader getDownloader();

        public File getFile();
    }
}

