/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.wizard;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.wizard.WizardPage;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.limewire.util.OSUtils;

public class Wizard {
    public static final int DIALOG_WIDTH = 540;
    public static final int DIALOG_HEIGHT = 360;
    protected JDialog dialog;
    private WizardPagePanel pageContainer = new WizardPagePanel();
    private WizardPage currentPage;
    public static final int ACTION_PREVIOUS = 1;
    public static final int ACTION_NEXT = 2;
    public static final int ACTION_FINISH = 4;
    public static final int ACTION_CANCEL = 8;
    private PreviousAction previousAction = new PreviousAction();
    private NextAction nextAction = new NextAction();
    private FinishAction finishAction = new FinishAction();
    private CancelAction cancelAction = new CancelAction();
    private AbstractAction[] actions = new AbstractAction[]{this.previousAction, this.nextAction, this.finishAction, this.cancelAction};

    public void addPage(WizardPage page) {
        page.setWizard(this);
        page.createPage();
        this.pageContainer.add(page);
    }

    public JDialog createDialog(Frame parent) {
        this.dialog = new JDialog(parent);
        this.dialog.setModal(true);
        if (!OSUtils.isUnix()) {
            this.dialog.setResizable(false);
        }
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Wizard.this.performCancel();
            }
        });
        GUIUtils.addHideAction((JComponent)this.dialog.getContentPane());
        Container container = this.dialog.getContentPane();
        BoxLayout containerLayout = new BoxLayout(container, 1);
        container.setLayout(containerLayout);
        JPanel setupPanel = new JPanel();
        setupPanel.setBorder(new EmptyBorder(1, 1, 0, 0));
        BoxLayout layout = new BoxLayout(setupPanel, 1);
        setupPanel.setLayout(layout);
        setupPanel.add(this.pageContainer);
        setupPanel.add(Box.createVerticalStrut(10));
        ButtonRow buttons = new ButtonRow(this.actions, 0, 12);
        buttons.setBorder(new EmptyBorder(5, 5, 5, 5));
        setupPanel.add(buttons);
        if (this.pageContainer.getFirst() != null) {
            this.show(this.pageContainer.getFirst());
        }
        container.add(setupPanel);
        int width = Math.max(((JComponent)container).getPreferredSize().width, 540);
        int height = Math.max(((JComponent)container).getPreferredSize().height, 360);
        ((JComponent)container).setPreferredSize(new Dimension(width, height));
        this.dialog.pack();
        return this.dialog;
    }

    public void enableActions(int actions) {
        this.previousAction.setEnabled((actions & 1) != 0);
        this.nextAction.setEnabled((actions & 2) != 0);
        this.finishAction.setEnabled((actions & 4) != 0);
        this.cancelAction.setEnabled((actions & 8) != 0);
    }

    public int getEnabledActions() {
        int actions = 0;
        if (this.previousAction.isEnabled()) {
            actions |= 1;
        }
        if (this.nextAction.isEnabled()) {
            actions |= 2;
        }
        if (this.finishAction.isEnabled()) {
            actions |= 4;
        }
        if (this.cancelAction.isEnabled()) {
            actions |= 8;
        }
        return actions;
    }

    public WizardPage getNextPage(WizardPage page) {
        return this.pageContainer.getNext(page);
    }

    public WizardPage getPreviousPage(WizardPage page) {
        return this.pageContainer.getPrevious(page);
    }

    public void performNext() {
        WizardPage page = this.currentPage.getNext();
        this.show(page);
    }

    public void performPrevious() {
        WizardPage page = this.currentPage.getPrevious();
        this.show(page);
    }

    public void performCancel() {
        this.dialog.dispose();
    }

    public void performFinish() {
        this.dialog.dispose();
    }

    private void show(WizardPage page) {
        this.pageContainer.show(page.getKey());
        this.currentPage = page;
        page.pageShown();
    }

    public void updateButtons() {
        if (this.currentPage == null) {
            this.finishAction.setEnabled(false);
            this.nextAction.setEnabled(false);
            this.previousAction.setEnabled(false);
        } else {
            boolean complete = this.currentPage.isPageComplete();
            boolean canFlipToNext = this.currentPage.canFlipToNextPage();
            this.finishAction.setEnabled(complete && !canFlipToNext);
            this.nextAction.setEnabled(complete && canFlipToNext);
            this.previousAction.setEnabled(this.currentPage.getPrevious() != null);
        }
    }

    private class WizardPagePanel
    extends JPanel {
        private final CardLayout CARD_LAYOUT = new CardLayout();

        WizardPagePanel() {
            this.setLayout(this.CARD_LAYOUT);
        }

        void add(WizardPage page) {
            this.add((Component)page, page.getKey());
        }

        public WizardPage getFirst() {
            if (this.getComponentCount() > 0) {
                return (WizardPage)this.getComponent(0);
            }
            return null;
        }

        public WizardPage getLast() {
            if (this.getComponentCount() > 0) {
                return (WizardPage)this.getComponent(this.getComponentCount() - 1);
            }
            return null;
        }

        public WizardPage getNext(WizardPage page) {
            Component[] pages = this.getComponents();
            for (int i = 0; i < pages.length; ++i) {
                if (pages[i] != page || i >= pages.length - 1) continue;
                return (WizardPage)pages[i + 1];
            }
            return null;
        }

        public WizardPage getPrevious(WizardPage page) {
            Component[] pages = this.getComponents();
            for (int i = 0; i < pages.length; ++i) {
                if (pages[i] != page || i <= 0) continue;
                return (WizardPage)pages[i - 1];
            }
            return null;
        }

        void show(String key) {
            this.CARD_LAYOUT.show(this, key);
        }
    }

    private class FinishAction
    extends AbstractAction {
        public FinishAction() {
            this.putValue("Name", I18n.tr("Finish"));
        }

        public void actionPerformed(ActionEvent e) {
            Wizard.this.performFinish();
        }
    }

    private class PreviousAction
    extends AbstractAction {
        public PreviousAction() {
            this.putValue("Name", I18n.tr("<< Back"));
        }

        public void actionPerformed(ActionEvent e) {
            Wizard.this.performPrevious();
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            this.putValue("Name", I18n.tr("Next >>"));
        }

        public void actionPerformed(ActionEvent e) {
            Wizard.this.performNext();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
        }

        public void actionPerformed(ActionEvent e) {
            Wizard.this.performCancel();
        }
    }
}

