/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailsPanel
extends JPanel {
    private Font boldFont = null;
    private List<NameValue<String>> list = new ArrayList<NameValue<String>>();

    public DetailsPanel() {
    }

    public DetailsPanel(LayoutManager layout) {
        super(layout);
    }

    private void add(String name, String value) {
        this.list.add(new NameValue<String>(name, value));
    }

    public void initWithFileDesc(FileDesc fd, String schemaUri) {
        String kind = MetaEditorUtil.getKind(fd.getFile());
        if (kind != null) {
            this.add(I18n.tr("Kind:"), kind);
        }
        SchemaReplyCollectionMapper map = GuiCoreMediator.getSchemaReplyCollectionMapper();
        LimeXMLReplyCollection collection = map.getReplyCollection(schemaUri);
        LimeXMLDocument doc = collection.getDocForHash(fd.getSHA1Urn());
        LimeXMLSchemaRepository rep = GuiCoreMediator.getLimeXMLSchemaRepository();
        LimeXMLSchema schema = rep.getSchema(schemaUri);
        if (doc != null) {
            for (SchemaFieldInfo infoField : schema.getCanonicalizedFields()) {
                String value;
                String field = infoField.getCanonicalizedFieldName();
                if (DetailsPanel.skipField(field) || (value = doc.getValue(field)) == null || value.equals("")) continue;
                String name = MetaEditorUtil.getStringResource(field);
                this.add(name, value);
            }
        }
        String name = I18n.tr("Size:");
        String value = GUIUtils.toUnitbytes(fd.getFileSize());
        this.add(name, value);
        name = I18n.tr("Date Modified:");
        value = GUIUtils.msec2DateTime(fd.lastModified());
        this.list.add(new NameValue<String>(name, value));
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        for (NameValue<String> next : this.list) {
            this.addLabel(next, layout, c);
        }
    }

    protected void addLabel(NameValue<String> pair, GridBagLayout bag, GridBagConstraints c) {
        JLabel name = new JLabel(pair.getKey(), 11);
        if (this.boldFont == null) {
            Font currentFont = name.getFont();
            this.boldFont = new Font(currentFont.getName(), 1, currentFont.getSize());
        }
        name.setFont(this.boldFont);
        c.anchor = 12;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 2, 3);
        bag.setConstraints(name, c);
        this.add(name);
        MultiLineLabel value = new MultiLineLabel(pair.getValue(), 300);
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        bag.setConstraints(value, c);
        this.add(value);
    }

    private static boolean skipField(String field) {
        if (field.equals("audios__audio__title__")) {
            return true;
        }
        if (field.equals("audios__audio__artist__")) {
            return true;
        }
        if (field.equals("audios__audio__album__")) {
            return true;
        }
        if (field.equals("audios__audio__seconds__")) {
            return true;
        }
        if (field.equals("audios__audio__comments__")) {
            return true;
        }
        return !MetaEditorUtil.contains(field);
    }
}

