/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.xml.editor.AbstractMetaEditorPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTabbedPane;
import org.limewire.collection.NameValue;

public abstract class MetaEditorTabbedPane
extends JTabbedPane {
    protected final FileDesc[] fds;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;

    public MetaEditorTabbedPane(FileDesc[] fds, String uri) {
        this.fds = fds;
        LimeXMLDocument[] docs = MetaEditorUtil.intersection(fds, uri);
        LimeXMLSchemaRepository rep = GuiCoreMediator.getLimeXMLSchemaRepository();
        this.schema = rep.getSchema(uri);
        if (this.schema == null) {
            throw new IllegalStateException("no schema!");
        }
        LimeXMLDocument doc = null;
        for (int i = 0; i < docs.length; ++i) {
            if (!this.schema.equals(docs[i].getSchema())) continue;
            doc = docs[i];
            break;
        }
        this.document = doc;
    }

    public FileDesc[] getFileDesc() {
        return this.fds;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getInput() {
        ArrayList<NameValue<String>> nameValueList = new ArrayList<NameValue<String>>();
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            AbstractMetaEditorPanel panel;
            List<NameValue<String>> list;
            Component tab = this.getComponentAt(i);
            if (!(tab instanceof AbstractMetaEditorPanel) || (list = (panel = (AbstractMetaEditorPanel)tab).getInput()) == null || list.isEmpty()) continue;
            nameValueList.addAll(list);
        }
        if (nameValueList.isEmpty()) {
            return null;
        }
        return GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(nameValueList, this.getSchema().getSchemaURI()).getXMLString();
    }

    public boolean hasDataChanged() {
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            AbstractMetaEditorPanel editor;
            Component tab = this.getComponentAt(i);
            if (!(tab instanceof AbstractMetaEditorPanel) || !(editor = (AbstractMetaEditorPanel)tab).checkInput()) continue;
            return true;
        }
        return false;
    }
}

