/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaEditorUtil {
    private static final Log LOG = LogFactory.getLog(MetaEditorUtil.class);
    private static final Map<String, String> XSD_MESSAGEBUNDLE_BRIDGE = new HashMap<String, String>();
    private static final String EMPTY_VALUE;

    private MetaEditorUtil() {
    }

    public static boolean contains(String resource) {
        return XSD_MESSAGEBUNDLE_BRIDGE.containsKey(resource);
    }

    public static String getStringResource(String resourceKey) {
        String rscKey = XSD_MESSAGEBUNDLE_BRIDGE.get(resourceKey);
        assert (rscKey != null) : "Unknown resourceKey: " + resourceKey;
        return I18n.tr(rscKey);
    }

    public static String getKind(File file) {
        String name = file.getName();
        if (LimeXMLUtils.isMP3File(name)) {
            return I18n.tr("MPEG-1 Audio Layer 3");
        }
        if (LimeXMLUtils.isM4AFile(name)) {
            return I18n.tr("MPEG-4 Audio");
        }
        if (LimeXMLUtils.isOGGFile(name)) {
            return I18n.tr("Ogg Vorbis");
        }
        return null;
    }

    public static LimeXMLDocument[] intersection(FileDesc[] fds, String schemaURI) {
        if (schemaURI != null) {
            schemaURI = schemaURI.toLowerCase(Locale.US);
        }
        HashMap map = new HashMap();
        block0: for (int i = 0; i < fds.length; ++i) {
            List<LimeXMLDocument> docs = fds[i].getLimeXMLDocuments();
            if (docs.isEmpty()) {
                map.clear();
                break;
            }
            for (LimeXMLDocument doc : docs) {
                String uri = doc.getSchemaURI().toLowerCase(Locale.US);
                if (schemaURI != null && !schemaURI.equals(uri)) continue;
                HashMap intersectionMap = (HashMap)map.get(uri);
                if (intersectionMap == null) {
                    intersectionMap = new HashMap();
                    map.put(uri, intersectionMap);
                }
                MetaEditorUtil.intersection(doc, intersectionMap);
                if (schemaURI == null) continue;
                continue block0;
            }
        }
        ArrayList<LimeXMLDocument> docs = new ArrayList<LimeXMLDocument>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            String uri = (String)entry.getKey();
            Set<Map.Entry<String, String>> intersection = MetaEditorUtil.clean((Map)entry.getValue()).entrySet();
            if (intersection.isEmpty()) continue;
            LimeXMLSchema schema = GuiCoreMediator.getLimeXMLSchemaRepository().getSchema(uri);
            if (schema == null) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("LimeXMLSchema for " + uri + " is null");
                continue;
            }
            boolean atLeastOneKnownFieldName = false;
            HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(schema.getCanonicalizedFieldNames()));
            for (Map.Entry<String, String> etr : intersection) {
                if (!fieldNames.contains(etr.getKey()) || etr.getValue() == null) continue;
                atLeastOneKnownFieldName = true;
                break;
            }
            if (atLeastOneKnownFieldName) {
                docs.add(GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(intersection, uri));
                continue;
            }
            if (!LOG.isErrorEnabled()) continue;
            LOG.error("All fields of " + intersection + " are unknown for Schema " + schema);
        }
        return docs.toArray(new LimeXMLDocument[0]);
    }

    private static Map intersection(LimeXMLDocument doc, Map<String, String> intersectionMap) {
        for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String current = intersectionMap.get(key);
            if (current == EMPTY_VALUE) continue;
            if (current == null || current.equals(value)) {
                intersectionMap.put(key, value);
                continue;
            }
            intersectionMap.put(key, EMPTY_VALUE);
        }
        HashSet<String> keys = new HashSet<String>(intersectionMap.keySet());
        keys.removeAll(doc.getNameSet());
        for (String next : keys) {
            intersectionMap.put(next, EMPTY_VALUE);
        }
        return intersectionMap;
    }

    private static Map<String, String> clean(Map<String, String> intersectionMap) {
        Iterator<String> it = intersectionMap.values().iterator();
        while (it.hasNext()) {
            if (it.next() != EMPTY_VALUE) continue;
            it.remove();
        }
        return intersectionMap;
    }

    public static LimeXMLDocument merge(LimeXMLDocument currentDoc, LimeXMLDocument newDoc) {
        if (!currentDoc.getSchemaURI().equalsIgnoreCase(newDoc.getSchemaURI())) {
            throw new IllegalArgumentException("Current XML document and new XML document must be of the same type!");
        }
        HashMap<String, Map.Entry<String, String>> map = new HashMap<String, Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : currentDoc.getNameValueSet()) {
            map.put(entry.getKey(), entry);
        }
        for (Map.Entry<String, String> entry : newDoc.getNameValueSet()) {
            map.put(entry.getKey(), entry);
        }
        return GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(map.values(), currentDoc.getSchemaURI());
    }

    static {
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio", I18nMarker.marktr("Audio"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__artist__", I18nMarker.marktr("Artist:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__album__", I18nMarker.marktr("Album:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__genre__", I18nMarker.marktr("Genre:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__year__", I18nMarker.marktr("Year:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__type__", I18nMarker.marktr("Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__track__", I18nMarker.marktr("Track:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__language__", I18nMarker.marktr("Language:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__seconds__", I18nMarker.marktr("Length:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__bitrate__", I18nMarker.marktr("Bitrate:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__comments__", I18nMarker.marktr("Comments:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__sha1__", I18nMarker.marktr("SHA1:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__price__", I18nMarker.marktr("Price:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__link__", I18nMarker.marktr("Link:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__action__", I18nMarker.marktr("Action:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("audios__audio__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video", I18nMarker.marktr("Video"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__type__", I18nMarker.marktr("Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__year__", I18nMarker.marktr("Year:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__rating__", I18nMarker.marktr("Rating:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__length__", I18nMarker.marktr("Length:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__comments__", I18nMarker.marktr("Comments:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__licensetype__", I18nMarker.marktr("License Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__action__", I18nMarker.marktr("Action:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__director__", I18nMarker.marktr("Director:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__studio__", I18nMarker.marktr("Studio:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__language__", I18nMarker.marktr("Language:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__stars__", I18nMarker.marktr("Stars: (Please separate with comma)"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__producer__", I18nMarker.marktr("Producer: (Please separate with comma)"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("videos__video__subtitles__", I18nMarker.marktr("Subtitles: (Please separate with comma)"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document", I18nMarker.marktr("Document"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__topic__", I18nMarker.marktr("Topic:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__author__", I18nMarker.marktr("Author:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("documents__document__licensetype__", I18nMarker.marktr("License Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application", I18nMarker.marktr("Application"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__name__", I18nMarker.marktr("Name:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__publisher__", I18nMarker.marktr("Publisher:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__platform__", I18nMarker.marktr("Platform:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__licensetype__", I18nMarker.marktr("License Type:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("applications__application__license", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image", I18nMarker.marktr("Image"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__title__", I18nMarker.marktr("Title:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__description__", I18nMarker.marktr("Description:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__artist__", I18nMarker.marktr("Artist:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__license__", I18nMarker.marktr("License:"));
        XSD_MESSAGEBUNDLE_BRIDGE.put("images__image__licensetype__", I18nMarker.marktr("License Type:"));
        EMPTY_VALUE = new String();
    }
}

