/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.gui.xml.editor.MetaDataSaver;
import com.limegroup.gnutella.gui.xml.editor.MetaEditor;
import com.limegroup.gnutella.gui.xml.editor.application.ApplicationTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.audio.AudioTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.document.DocumentTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.image.ImageTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.video.VideoTabbedPane;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class XmlTypeEditor
extends MetaEditor {
    private static final String SELECTION_PANEL = "SELECTION_PANEL";
    private static final String TABBED_PANEL = "TABBED_PANEL";
    private JPanel cardPanel;
    private JPanel selectionPanel;
    private JButton backButton;
    private String[] schemas;
    private JList schemaList;

    public XmlTypeEditor(Frame parent, FileDesc[] fds, String fileName) {
        super(parent, fds, fileName);
        LimeXMLSchema schema = this.hasXMLSelected();
        if (schema != null) {
            this.createAndDisplayTab(schema);
        }
    }

    protected void initCenterPanel() {
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.add((Component)this.getSelectionPanel(), SELECTION_PANEL);
        this.add((Component)this.cardPanel, "Center");
    }

    private JPanel getSelectionPanel() {
        this.selectionPanel = new JPanel();
        this.selectionPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.selectionPanel.setLayout(new BoxLayout(this.selectionPanel, 1));
        JLabel label = new JLabel(I18n.tr("Unknown file type. Please choose the type that best describes this file."));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.selectionPanel.add(label);
        this.schemas = this.getSchemaList();
        String[] unusedSchemas = new String[this.schemas.length];
        for (int j = 0; j < unusedSchemas.length; ++j) {
            unusedSchemas[j] = XMLUtils.getTitleForSchemaURI(this.schemas[j]);
        }
        this.schemaList = new JList<String>(unusedSchemas);
        this.schemaList.setSelectionMode(0);
        JScrollPane lowerLeftScroller = new JScrollPane(this.schemaList);
        this.selectionPanel.add(lowerLeftScroller);
        return this.selectionPanel;
    }

    protected void initSouthPanel() {
        super.initSouthPanel();
        JPanel panel = new JPanel();
        this.backButton = new JButton(I18n.tr("Back"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XmlTypeEditor.this.backAction();
            }
        });
        panel.add(this.backButton);
        this.okButton.setText(I18n.tr("Next"));
        this.southPanel.add((Component)panel, "West");
    }

    protected void saveAndDisposeWindow() {
        if (this.selectionPanel.isVisible()) {
            int index = this.schemaList.getSelectedIndex();
            if (index > -1) {
                LimeXMLSchemaRepository rep = GuiCoreMediator.getLimeXMLSchemaRepository();
                LimeXMLSchema schema = rep.getSchema(this.schemas[index]);
                this.createAndDisplayTab(schema);
            }
        } else {
            for (int i = 0; i < this.fds.length; ++i) {
                List<LimeXMLDocument> docs = this.fds[i].getLimeXMLDocuments();
                for (LimeXMLDocument doc : docs) {
                    if (doc == null) continue;
                    String uri = doc.getSchemaURI();
                    SchemaReplyCollectionMapper map = GuiCoreMediator.getSchemaReplyCollectionMapper();
                    LimeXMLReplyCollection collection = map.getReplyCollection(uri);
                    assert (collection != null) : "Trying to remove data from a non-existent collection";
                    collection.removeDoc(this.fds[i]);
                }
            }
            MetaDataSaver saver = new MetaDataSaver(this.tabbedPane.getFileDesc(), this.tabbedPane.getSchema(), this.tabbedPane.getInput());
            saver.saveMetaData();
            this.disposeWindow();
        }
    }

    private LimeXMLSchema hasXMLSelected() {
        for (int i = 0; i < this.fds.length; ++i) {
            LimeXMLDocument doc = this.fds[i].getXMLDocument();
            if (doc == null) continue;
            doc.getXMLString();
            return doc.getSchema();
        }
        return null;
    }

    private String[] getSchemaList() {
        LimeXMLSchemaRepository rep = GuiCoreMediator.getLimeXMLSchemaRepository();
        return rep.getAvailableSchemaURIs();
    }

    private void createAndDisplayTab(LimeXMLSchema schema) {
        this.createTabs(schema);
        this.cardPanel.add((Component)this.tabbedPane, TABBED_PANEL);
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, TABBED_PANEL);
        this.pack();
        this.backButton.setEnabled(true);
        this.okButton.setText(I18n.tr("OK"));
    }

    private void createTabs(LimeXMLSchema schema) {
        if (schema.getDescription().equals("audio")) {
            if (!(this.tabbedPane instanceof AudioTabbedPane)) {
                this.tabbedPane = new AudioTabbedPane(this.fds);
            }
        } else if (schema.getDescription().equals("video")) {
            if (!(this.tabbedPane instanceof VideoTabbedPane)) {
                this.tabbedPane = new VideoTabbedPane(this.fds);
            }
        } else if (schema.getDescription().equals("application")) {
            if (!(this.tabbedPane instanceof ApplicationTabbedPane)) {
                this.tabbedPane = new ApplicationTabbedPane(this.fds);
            }
        } else if (schema.getDescription().equals("document")) {
            if (!(this.tabbedPane instanceof DocumentTabbedPane)) {
                this.tabbedPane = new DocumentTabbedPane(this.fds);
            }
        } else if (schema.getDescription().equals("image") && !(this.tabbedPane instanceof ImageTabbedPane)) {
            this.tabbedPane = new ImageTabbedPane(this.fds);
        }
    }

    private void backAction() {
        if (this.selectionPanel.isVisible()) {
            return;
        }
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, SELECTION_PANEL);
        this.okButton.setText(I18n.tr("Next"));
        this.backButton.setEnabled(false);
    }
}

