/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;
import org.limewire.io.ByteReader;

class BlockingHandshakeSupport
extends HandshakeSupport {
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    BlockingHandshakeSupport(Socket socket, InputStream in, OutputStream out) {
        super(socket.getInetAddress().getHostAddress());
        this.socket = socket;
        this.in = in;
        this.out = out;
    }

    String readLine() throws IOException {
        return this.readLine(8000);
    }

    String readLine(int timeout) throws IOException {
        int oldTimeout = this.socket.getSoTimeout();
        try {
            this.socket.setSoTimeout(timeout);
            String line = new ByteReader(this.in).readLine();
            if (line == null) {
                throw new IOException("read null line");
            }
            String string = line;
            return string;
        }
        catch (NullPointerException npe) {
            throw new IOException();
        }
        finally {
            this.socket.setSoTimeout(oldTimeout);
        }
    }

    void readHeaders() throws IOException {
        this.readHeaders(8000);
    }

    void readHeaders(int timeout) throws IOException {
        block2: {
            do {
                String line;
                if ((line = this.readLine(timeout)) == null) {
                    throw new IOException("unexpected end of file");
                }
                if (!this.processReadHeader(line)) break block2;
            } while (this.getHeadersReadSize() <= ConnectionSettings.MAX_HANDSHAKE_HEADERS.getValue());
            throw new IOException("too many headers");
        }
    }

    void writeConnectLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.appendConnectLine(sb);
        this.writeLine(sb.toString());
    }

    void writeResponse(HandshakeResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.appendResponse(response, sb);
        this.writeLine(sb.toString());
    }

    void writeLine(String s) throws IOException {
        if (s == null || s.equals("")) {
            throw new NullPointerException("null or empty string: " + s);
        }
        byte[] bytes = s.getBytes();
        this.out.write(bytes);
        this.out.flush();
    }

    void sendHeaders(Properties props) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.appendHeaders(props, sb);
        this.writeLine(sb.toString());
    }
}

