/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeServices;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.limewire.io.IpPort;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandshakeResponse {
    private static final Version OLD_LIME_VERSION;
    public static final int OK = 200;
    public static final String OK_MESSAGE = "OK";
    public static final int CRAWLER_CODE = 593;
    public static final String CRAWLER_MESSAGE = "Hi";
    public static final int SHIELDED = 503;
    public static final int SLOTS_FULL = 503;
    public static final int DEFAULT_BAD_STATUS_CODE = 503;
    public static final String DEFAULT_BAD_STATUS_MESSAGE = "Service Not Available";
    public static final int LOCALE_NO_MATCH = 577;
    public static final String LOCALE_NO_MATCH_MESSAGE = "Service Not Available";
    private final int STATUS_CODE;
    private final String STATUS_MESSAGE;
    private final Properties HEADERS;
    private Boolean _supportsGGEP;
    private final boolean GOOD_LEAF;
    private final boolean GOOD_ULTRAPEER;
    private final int DEGREE;
    private final boolean HIGH_DEGREE;
    private final boolean ULTRAPEER_QRP;
    private final byte MAX_TTL;
    private final boolean DYNAMIC_QUERY;
    private final boolean ULTRAPEER;
    private final boolean LEAF;
    private final boolean DEFLATE_ENCODED;
    private final boolean PROBE_QUERIES;
    private final boolean PONG_CACHING;
    private final boolean GUESS_CAPABLE;
    private final boolean IS_CRAWLER;
    private final boolean IS_LIMEWIRE;
    private final boolean IS_OLD_LIMEWIRE;
    private final boolean NO_REQUERYING;
    private final String LOCALE_PREF;
    private final int LISTEN_PORT;
    private final Version limeVersion;
    private static final int NUM_X_TRY_ULTRAPEER_HOSTS = 10;
    private static final HandshakeResponse EMPTY_RESPONSE;

    protected HandshakeResponse(Properties headers) {
        this(200, OK_MESSAGE, headers);
    }

    protected HandshakeResponse(int code, String message) {
        this(code, message, new Properties());
    }

    HandshakeResponse(int code, String message, Properties headers) {
        this.STATUS_CODE = code;
        this.STATUS_MESSAGE = message;
        this.HEADERS = headers;
        this.DEGREE = HandshakeResponse.extractIntHeaderValue(this.HEADERS, "X-Degree", 6);
        this.HIGH_DEGREE = this.getNumIntraUltrapeerConnections() >= 15;
        this.ULTRAPEER_QRP = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ultrapeer-Query-Routing", 0.1f);
        this.MAX_TTL = HandshakeResponse.extractByteHeaderValue(this.HEADERS, "X-Max-TTL", (byte)4);
        this.DYNAMIC_QUERY = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Dynamic-Querying", 0.1f);
        this.PROBE_QUERIES = HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Ext-Probes", 0.1f);
        this.NO_REQUERYING = HandshakeResponse.isFalseValue(this.HEADERS, "X-Requeries");
        String userAgent = HandshakeResponse.extractStringHeaderValue(headers, "User-Agent").toLowerCase();
        this.IS_LIMEWIRE = userAgent.startsWith("limewire") || userAgent.startsWith("frostwire");
        this.GOOD_ULTRAPEER = this.isHighDegreeConnection() && this.isUltrapeerQueryRoutingConnection() && this.getMaxTTL() < 5 && this.isDynamicQueryConnection();
        this.GOOD_LEAF = this.GOOD_ULTRAPEER && (this.IS_LIMEWIRE || this.NO_REQUERYING);
        this.ULTRAPEER = HandshakeResponse.isTrueValue(this.HEADERS, "X-Ultrapeer");
        this.LEAF = HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer");
        this.DEFLATE_ENCODED = HandshakeResponse.isStringValue(this.HEADERS, HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        this.PONG_CACHING = HandshakeResponse.isVersionOrHigher(headers, "Pong-Caching", 0.1f);
        this.GUESS_CAPABLE = HandshakeResponse.isVersionOrHigher(headers, "X-Guess", 0.1f);
        this.IS_CRAWLER = HandshakeResponse.isVersionOrHigher(headers, "Crawler", 0.1f);
        Version version = null;
        this.IS_OLD_LIMEWIRE = this.IS_LIMEWIRE ? (version = this.extractVersion(HandshakeResponse.extractStringHeaderValue(headers, "User-Agent"))) != null && version.compareTo(OLD_LIME_VERSION) < 0 : false;
        this.limeVersion = version;
        String loc = HandshakeResponse.extractStringHeaderValue(headers, "X-Locale-Pref");
        this.LOCALE_PREF = loc.equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : loc;
        this.LISTEN_PORT = HandshakeResponse.extractIntHeaderValueAfter(headers, "Listen-IP", ":", -1);
    }

    private Version extractVersion(String userAgent) {
        StringTokenizer tok = new StringTokenizer(userAgent, "/. ");
        if (tok.countTokens() < 3) {
            return null;
        }
        tok.nextToken();
        String v = tok.nextToken() + "." + tok.nextToken() + ".";
        v = tok.hasMoreTokens() ? v + tok.nextToken() : v + "0";
        try {
            return new Version(v);
        }
        catch (VersionFormatException vfe) {
            return null;
        }
    }

    public static HandshakeResponse createEmptyResponse() {
        return EMPTY_RESPONSE;
    }

    public static HandshakeResponse createResponse(Properties headers) {
        return new HandshakeResponse(headers);
    }

    public static HandshakeResponse createRemoteResponse(String line, Properties headers) throws IOException {
        int code = HandshakeResponse.extractCode(line);
        if (code == -1) {
            throw new IOException("could not parse status code: " + line);
        }
        String message = HandshakeResponse.extractMessage(line);
        if (message == null) {
            throw new IOException("could not parse status message: " + line);
        }
        return new HandshakeResponse(code, message, headers);
    }

    static HandshakeResponse createAcceptIncomingResponse(HandshakeResponse response, Properties headers, HandshakeServices handshakeServices) {
        return new HandshakeResponse(HandshakeResponse.addXTryHeader(response, headers, handshakeServices));
    }

    static HandshakeResponse createAcceptOutgoingResponse(Properties headers) {
        return new HandshakeResponse(headers);
    }

    static HandshakeResponse createCrawlerResponse(HandshakeServices handshakeServices) {
        Properties headers = new Properties();
        headers.put("User-Agent", LimeWireUtils.getHttpServer());
        headers.put("X-Ultrapeer", Boolean.toString(handshakeServices.isUltrapeer()));
        List<? extends IpPort> leaves = handshakeServices.getLeafNodes();
        headers.put("Leaves", HandshakeResponse.createEndpointString(leaves, leaves.size()));
        List<? extends IpPort> ultrapeers = handshakeServices.getUltrapeerNodes();
        headers.put("Peers", HandshakeResponse.createEndpointString(ultrapeers, ultrapeers.size()));
        return new HandshakeResponse(593, CRAWLER_MESSAGE, headers);
    }

    static HandshakeResponse createUltrapeerRejectIncomingResponse(HandshakeResponse hr, HandshakeStatus status, HandshakeServices handshakeServices) {
        return new HandshakeResponse(503, status.getMessage(), HandshakeResponse.addXTryHeader(hr, new Properties(), handshakeServices));
    }

    static HandshakeResponse createRejectOutgoingResponse(HandshakeStatus status) {
        return new HandshakeResponse(503, status.getMessage(), new Properties());
    }

    static HandshakeResponse createLeafRejectIncomingResponse(HandshakeResponse hr, HandshakeStatus status, HandshakeServices handshakeServices) {
        return new HandshakeResponse(503, status.getMessage(), HandshakeResponse.addXTryHeader(hr, new Properties(), handshakeServices));
    }

    static HandshakeResponse createLeafRejectOutgoingResponse(HandshakeStatus status) {
        return new HandshakeResponse(503, status.getMessage());
    }

    static HandshakeResponse createLeafRejectLocaleOutgoingResponse() {
        return new HandshakeResponse(577, "Service Not Available");
    }

    static String createEndpointString(Collection<? extends IpPort> hosts) {
        return HandshakeResponse.createEndpointString(hosts, 10);
    }

    static String createEndpointString(Collection<? extends IpPort> hosts, int limit) {
        StringBuilder sb = new StringBuilder();
        Iterator<? extends IpPort> iter = hosts.iterator();
        for (int i = 0; iter.hasNext() && i < limit; ++i) {
            IpPort host = iter.next();
            sb.append(host.getAddress());
            sb.append(":");
            sb.append(host.getPort());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    static int extractCode(String line) {
        int statusMessageIndex = line.indexOf(" ");
        if (statusMessageIndex == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(line.substring(0, statusMessageIndex).trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static String extractMessage(String line) {
        int statusMessageIndex = line.indexOf(" ");
        if (statusMessageIndex == -1) {
            return null;
        }
        return line.substring(statusMessageIndex).trim();
    }

    static Properties addXTryHeader(HandshakeResponse hr, Properties headers, HandshakeServices handshakeServices) {
        Collection<IpPort> hosts = handshakeServices.getAvailableHosts(hr.isUltrapeer(), hr.getLocalePref(), 10);
        headers.put("X-Try-Ultrapeers", HandshakeResponse.createEndpointString(hosts));
        return headers;
    }

    public int getStatusCode() {
        return this.STATUS_CODE;
    }

    public String getStatusMessage() {
        return this.STATUS_MESSAGE;
    }

    public boolean notOKStatusCode() {
        return this.STATUS_CODE != 200;
    }

    public boolean isAccepted() {
        return this.STATUS_CODE == 200;
    }

    public String getStatusLine() {
        return new String(this.STATUS_CODE + " " + this.STATUS_MESSAGE);
    }

    public Properties props() {
        return this.HEADERS;
    }

    public String getProperty(String prop) {
        return this.HEADERS.getProperty(prop);
    }

    public String getUserAgent() {
        return this.HEADERS.getProperty("User-Agent");
    }

    public byte getMaxTTL() {
        return this.MAX_TTL;
    }

    public String getXTryUltrapeers() {
        return HandshakeResponse.extractStringHeaderValue(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasXTryUltrapeers() {
        return HandshakeResponse.headerExists(this.HEADERS, "X-Try-Ultrapeers");
    }

    public boolean hasLeafGuidance() {
        return HandshakeResponse.isFalseValue(this.HEADERS, "X-Ultrapeer-Needed");
    }

    public int getNumIntraUltrapeerConnections() {
        return this.DEGREE;
    }

    public boolean isHighDegreeConnection() {
        return this.HIGH_DEGREE;
    }

    public boolean isLimeWire() {
        return this.IS_LIMEWIRE;
    }

    public boolean isOldLimeWire() {
        return this.IS_OLD_LIMEWIRE;
    }

    public Version getLimeVersion() {
        return this.limeVersion;
    }

    public boolean isGoodLeaf() {
        return this.GOOD_LEAF;
    }

    public boolean isDeflateEnabled() {
        return this.DEFLATE_ENCODED;
    }

    public boolean isDeflateAccepted() {
        return ConnectionSettings.ENCODE_DEFLATE.getValue() && HandshakeResponse.containsStringValue(this.HEADERS, HeaderNames.ACCEPT_ENCODING, HeaderNames.DEFLATE_VALUE);
    }

    public boolean isGoodUltrapeer() {
        return this.GOOD_ULTRAPEER;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this.ULTRAPEER_QRP;
    }

    public boolean isLeaf() {
        return this.LEAF;
    }

    public boolean isUltrapeer() {
        return this.ULTRAPEER;
    }

    public boolean isGUESSCapable() {
        return this.GUESS_CAPABLE;
    }

    public boolean isGUESSUltrapeer() {
        return this.isGUESSCapable() && this.isUltrapeer();
    }

    public boolean isTempConnection() {
        String value = this.HEADERS.getProperty("X-Temp-Connection");
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public boolean supportsGGEP() {
        if (this._supportsGGEP == null) {
            String value = this.HEADERS.getProperty("GGEP");
            this._supportsGGEP = new Boolean(value != null);
        }
        return this._supportsGGEP;
    }

    public float supportsVendorMessages() {
        String value = this.HEADERS.getProperty("Vendor-Message");
        if (value != null && !value.equals("")) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public boolean supportsPongCaching() {
        return this.PONG_CACHING;
    }

    public String getVersion() {
        return this.HEADERS.getProperty("X-Version");
    }

    public boolean isQueryRoutingEnabled() {
        return HandshakeResponse.isVersionOrHigher(this.HEADERS, "X-Query-Routing", 0.1f);
    }

    public boolean isDynamicQueryConnection() {
        return this.DYNAMIC_QUERY;
    }

    public boolean supportsProbeQueries() {
        return this.PROBE_QUERIES;
    }

    public boolean isCrawler() {
        return this.IS_CRAWLER;
    }

    public String getLocalePref() {
        return this.LOCALE_PREF;
    }

    public int getListeningPort() {
        return this.LISTEN_PORT;
    }

    private static boolean headerExists(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        return value != null;
    }

    private static boolean isTrueValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private static boolean isFalseValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("false");
    }

    private static boolean isStringValue(Properties headers, String headerName, String headerValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase(headerValue);
    }

    private static boolean containsStringValue(Properties headers, String headerName, String headerValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        if (value.equalsIgnoreCase(headerValue)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equalsIgnoreCase(headerValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVersionOrHigher(Properties headers, String headerName, float minVersion) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return false;
        }
        try {
            Float f = new Float(value);
            return f.floatValue() >= minVersion;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int extractIntHeaderValue(Properties headers, String headerName, int defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static int extractIntHeaderValueAfter(Properties headers, String headerName, String token, int defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        int idx = value.indexOf(token) + 1;
        if (idx == 0 || idx == value.length()) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value.substring(idx));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static byte extractByteHeaderValue(Properties headers, String headerName, byte defaultValue) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Byte.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String extractStringHeaderValue(Properties headers, String headerName) {
        String value = headers.getProperty(headerName);
        if (value == null) {
            return "";
        }
        return value;
    }

    public String toString() {
        return "<" + this.STATUS_CODE + ", " + this.STATUS_MESSAGE + ">" + this.HEADERS;
    }

    static {
        Version v = null;
        try {
            v = new Version("3.4.0");
        }
        catch (VersionFormatException versionFormatException) {
            // empty catch block
        }
        OLD_LIME_VERSION = v;
        EMPTY_RESPONSE = new HandshakeResponse(new Properties());
    }
}

