/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeServices;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import java.util.Collection;
import java.util.List;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HandshakeServicesImpl
implements HandshakeServices {
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkManager networkManager;
    private final ConnectionServices connectionServices;

    @Inject
    HandshakeServicesImpl(Provider<ConnectionManager> connectionManager, NetworkManager networkManager, ConnectionServices connectionServices) {
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.connectionServices = connectionServices;
    }

    @Override
    public HandshakeStatus getHandshakeStatusForResponse(HandshakeResponse handshakeResponse) {
        return this.connectionManager.get().allowConnection(handshakeResponse);
    }

    @Override
    public List<? extends IpPort> getLeafNodes() {
        return this.connectionManager.get().getInitializedClientConnections();
    }

    @Override
    public IpPort getLocalIpPort() {
        return new IpPortImpl(this.networkManager.getAddress(), this.networkManager.getPort());
    }

    @Override
    public List<? extends IpPort> getUltrapeerNodes() {
        return this.connectionManager.get().getInitializedConnections();
    }

    @Override
    public Collection<IpPort> getAvailableHosts(boolean isUltrapeer, String locale, int num) {
        return this.connectionServices.getPreferencedHosts(isUltrapeer, locale, num);
    }

    @Override
    public HandshakeStatus getHandshakeStatusForResponseAsLeaf(HandshakeResponse handshakeResponse) {
        return this.connectionManager.get().allowConnectionAsLeaf(handshakeResponse);
    }

    @Override
    public boolean isLeafDemotionAllowed() {
        return this.connectionManager.get().allowLeafDemotion();
    }

    @Override
    public boolean isUltrapeer() {
        return this.connectionManager.get().isSupernode();
    }

    @Override
    public boolean isUltrapeerNeeded() {
        return this.connectionManager.get().supernodeNeeded();
    }
}

