/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.http.HeaderSupport;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

class HandshakeSupport
extends HeaderSupport {
    private String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    private static final String GNUTELLA_06 = "GNUTELLA/0.6";
    private static final String CONNECT = "CONNECT/";
    private static final String CRLF = "\r\n";
    private final Properties readHeaders;
    private final Properties writtenHeaders;
    private final String remoteAddress;
    private String remoteResponse;

    HandshakeSupport(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.readHeaders = new Properties();
        this.writtenHeaders = new Properties();
    }

    HandshakeResponse createRemoteResponse(String connectLine) throws IOException {
        this.remoteResponse = connectLine.substring(GNUTELLA_06.length()).trim();
        return HandshakeResponse.createRemoteResponse(this.remoteResponse, this.readHeaders);
    }

    void appendConnectLine(StringBuilder sb) {
        sb.append(this.GNUTELLA_CONNECT_06).append(CRLF);
    }

    void appendResponse(HandshakeResponse response, StringBuilder sb) {
        sb.append(GNUTELLA_06).append(" ").append(response.getStatusLine()).append(CRLF);
        this.appendHeaders(response.props(), sb);
    }

    void appendHeaders(Properties props, StringBuilder sb) {
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = props.getProperty(key);
                String toWrite = this.processKeyValueForWriting(key, value);
                sb.append(toWrite);
            }
        }
        sb.append(CRLF);
    }

    boolean isConnectLineValid(String s) {
        return s.startsWith(GNUTELLA_06);
    }

    boolean notLessThan06(String line) {
        int i = line.indexOf(CONNECT);
        if (i < 0) {
            return false;
        }
        try {
            float f = Float.parseFloat(line.substring(i + CONNECT.length()));
            return f >= 0.6f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean processReadHeader(String line) {
        if (line.equals("")) {
            return false;
        }
        int i = line.indexOf(58);
        if (i > 0) {
            String key = line.substring(0, i);
            String value = line.substring(i + 1).trim();
            this.readHeaders.put(key, value);
        }
        return true;
    }

    String processKeyValueForWriting(String key, String value) {
        if ("Remote-IP".equals(key)) {
            value = this.remoteAddress;
        }
        if (value == null) {
            value = "";
        }
        this.writtenHeaders.put(key, value);
        return key + ": " + value + CRLF;
    }

    public int getHeadersReadSize() {
        return this.readHeaders.size();
    }

    HandshakeResponse getReadHandshakeRemoteResponse() throws IOException {
        return HandshakeResponse.createRemoteResponse(this.remoteResponse, this.readHeaders);
    }

    HandshakeResponse getReadHandshakeResponse() {
        return HandshakeResponse.createResponse(this.readHeaders);
    }

    HandshakeResponse getWrittenHandshakeResponse() {
        return HandshakeResponse.createResponse(this.writtenHeaders);
    }
}

