/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.HeaderInterceptor;
import org.limewire.io.NetworkUtils;

public class FeatureHeaderInterceptor
implements HeaderInterceptor {
    private static final Log LOG = LogFactory.getLog(FeatureHeaderInterceptor.class);
    private HTTPUploader uploader;

    public FeatureHeaderInterceptor(HTTPUploader uploader) {
        this.uploader = uploader;
    }

    public void process(Header header, HttpContext context) throws HttpException, IOException {
        if (this.readChatHeader(header) || this.readContentURNHeader(header) || this.readQueueVersion(header) || this.readFeatureHeader(header) || this.readXDownloadedHeader(header) || this.readNodeHeader(header)) {
            // empty if block
        }
    }

    private boolean readChatHeader(Header header) throws IOException {
        if (!HTTPHeaderName.CHAT.matches(header)) {
            return false;
        }
        if (!this.setHostAndPort(header.getValue())) {
            throw new ProblemReadingHeaderException();
        }
        this.uploader.setChatEnabled(true);
        this.uploader.setBrowseHostEnabled(true);
        return true;
    }

    private boolean readXDownloadedHeader(Header header) {
        if (!HTTPHeaderName.DOWNLOADED.matches(header)) {
            return false;
        }
        try {
            this.uploader.setTotalAmountUploadedBefore(Integer.parseInt(header.getValue()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private boolean readContentURNHeader(Header header) {
        if (!HTTPHeaderName.GNUTELLA_CONTENT_URN.matches(header)) {
            return false;
        }
        try {
            this.uploader.setRequestedURN(URN.createSHA1Urn(header.getValue()));
        }
        catch (IOException e) {
            this.uploader.setRequestedURN(URN.INVALID);
        }
        return true;
    }

    private boolean readQueueVersion(Header header) {
        if (!HTTPHeaderName.QUEUE.matches(header)) {
            return false;
        }
        this.uploader.setSupportsQueueing(true);
        return true;
    }

    private boolean readFeatureHeader(Header header) {
        if (!HTTPHeaderName.FEATURES.matches(header)) {
            return false;
        }
        String value = header.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug("reading feature header: " + value);
        }
        StringTokenizer tok = new StringTokenizer(value, ",");
        while (tok.hasMoreTokens()) {
            String feature = tok.nextToken();
            String protocol = "";
            int slash = feature.indexOf("/");
            protocol = slash == -1 ? feature.toLowerCase().trim() : feature.substring(0, slash).toLowerCase().trim();
            if (protocol.equals("chat")) {
                this.uploader.setChatEnabled(true);
                continue;
            }
            if (protocol.equals("browse")) {
                this.uploader.setBrowseHostEnabled(true);
                continue;
            }
            if (protocol.equals("queue")) {
                this.uploader.setSupportsQueueing(true);
                continue;
            }
            if (protocol.equals("fwalt")) {
                this.uploader.getAltLocTracker().setWantsFAlts(true);
                continue;
            }
            if (!protocol.equals("fwt")) continue;
            try {
                this.uploader.getAltLocTracker().setFwtVersion((int)HTTPUtils.parseFeatureToken(feature));
                this.uploader.getAltLocTracker().setWantsFAlts(true);
            }
            catch (ProblemReadingHeaderException prhe) {}
        }
        return true;
    }

    private boolean readNodeHeader(Header header) {
        if (!HTTPHeaderName.NODE.matches(header)) {
            return false;
        }
        this.setHostAndPort(header.getValue());
        return true;
    }

    private boolean setHostAndPort(String value) {
        int port = -1;
        StringTokenizer st = new StringTokenizer(value, ":");
        if (st.countTokens() == 2) {
            try {
                InetAddress host = InetAddress.getByName(st.nextToken().trim());
                port = Integer.parseInt(st.nextToken().trim());
                if (NetworkUtils.isValidPort(port)) {
                    this.uploader.setHost(host.getHostAddress());
                    this.uploader.setGnutellaPort(port);
                    return true;
                }
            }
            catch (UnknownHostException ignore) {
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return false;
    }
}

