/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPMessage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class HTTPRequestMethod {
    private final String METHOD_NAME;
    public static final HTTPRequestMethod GET = new HTTPRequestMethod("GET"){

        public void writeHttpResponse(HTTPMessage response, OutputStream os) throws IOException {
            if (response == null) {
                throw new NullPointerException("cannot write null response object");
            }
            if (os == null) {
                throw new NullPointerException("cannot write to null output stream");
            }
            response.writeMessageHeaders(os);
            response.writeMessageBody(os);
            os.flush();
        }
    };
    public static final HTTPRequestMethod HEAD = new HTTPRequestMethod("HEAD"){

        public void writeHttpResponse(HTTPMessage response, OutputStream os) throws IOException {
            if (response == null) {
                throw new NullPointerException("cannot write null response object");
            }
            if (os == null) {
                throw new NullPointerException("cannot write to null output stream");
            }
            response.writeMessageHeaders(os);
            os.flush();
        }
    };

    private HTTPRequestMethod(String methodName) {
        this.METHOD_NAME = methodName.toUpperCase();
    }

    public String getMethod() {
        return this.METHOD_NAME;
    }

    public abstract void writeHttpResponse(HTTPMessage var1, OutputStream var2) throws IOException;

    public String toString() {
        return "HTTPRequestMethod: " + this.METHOD_NAME;
    }
}

