/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.licenses.CCConstants;

public class PublishedCCLicense {
    private static final String DATE_TAG = "dc:date";
    private static final String RIGHTS_TAG = "dc:rights";
    private static final String TITLE_TAG = "dc:title";
    private static final String DESCRIPTION_TAG = "dc:description";
    private static final String AGENT = "Agent";
    private static final String LICENSE_TAG = "license rdf:resource=\"";

    public static String getRDFRepresentation(String holder, String title, String year, String description, String uri, int type) {
        assert (holder != null && year != null && title != null && uri != null);
        StringBuilder ret = new StringBuilder();
        ret.append("<!-- <rdf:RDF xmlns=\"http://web.resource.org/cc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">").append("\n");
        ret.append("<Work rdf:about=\"");
        ret.append(uri);
        ret.append("\">");
        ret.append("<dc:date>" + year + "</" + DATE_TAG + ">");
        ret.append("<dc:title>" + title + "</" + TITLE_TAG + ">");
        if (description != null) {
            ret.append("<dc:description>" + description + "</" + DESCRIPTION_TAG + ">");
        }
        ret.append("<dc:rights><Agent><dc:title>" + holder + "</" + TITLE_TAG + "></" + AGENT + "></" + RIGHTS_TAG + ">");
        ret.append("<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/Sound\" />");
        ret.append("<license rdf:resource=\"" + CCConstants.getLicenseURI(type) + "\" />");
        ret.append("</Work>").append("\n");
        ret.append(CCConstants.getLicenseElement(type)).append("\n");
        ret.append("</rdf:RDF> -->");
        return ret.toString();
    }

    public static String getEmbeddableString(String holder, String title, String year, String url, String description, int type) {
        assert (holder != null && year != null && title != null && url != null);
        StringBuilder ret = new StringBuilder();
        ret.append(year + " ");
        ret.append(holder + ". ");
        ret.append("Licensed to the public under ");
        ret.append(CCConstants.getLicenseURI(type) + " ");
        ret.append("verify at " + url);
        return ret.toString();
    }
}

