/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.lws.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.lws.server.LWSManager;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandler;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandlerWithCallback;
import com.limegroup.gnutella.settings.LWSSettings;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.protocol.HttpRequestHandler;
import org.limewire.lws.server.AbstractReceivesCommandsFromDispatcher;
import org.limewire.lws.server.LWSConnectionListener;
import org.limewire.lws.server.LWSDispatcher;
import org.limewire.lws.server.LWSDispatcherFactory;
import org.limewire.lws.server.LWSDispatcherFactoryImpl;
import org.limewire.lws.server.LWSSenderOfMessagesToServer;
import org.limewire.lws.server.StringCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class LWSManagerImpl
implements LWSManager,
LWSSenderOfMessagesToServer {
    static final String COMMAND_PAGE_WITH_LEADING_AND_TRAILING_SLASHES = "/store/app/pages/client/ClientCom/command/";
    private final LWSDispatcher dispatcher;
    private final Map<String, LWSManagerCommandResponseHandler> commands2handlers = new HashMap<String, LWSManagerCommandResponseHandler>();
    private final Map<String, List<LWSManager.Listener>> commands2listenerLists = new HashMap<String, List<LWSManager.Listener>>();
    private final String hostNameAndPort;
    private final HttpExecutor exe;
    private boolean isConnected;

    @Inject
    public LWSManagerImpl(HttpExecutor exe) {
        this(exe, new LWSDispatcherFactoryImpl());
    }

    public LWSManagerImpl(HttpExecutor exe, LWSDispatcherFactory lwsDispatcherFactory) {
        this(exe, LWSSettings.LWS_AUTHENTICATION_HOSTNAME.getValue(), LWSSettings.LWS_AUTHENTICATION_PORT.getValue(), lwsDispatcherFactory);
    }

    public LWSManagerImpl(HttpExecutor exe, String host, int port, LWSDispatcherFactory lwsDispatcherFactory) {
        this.exe = exe;
        this.dispatcher = lwsDispatcherFactory.createDispatcher(this, new AbstractReceivesCommandsFromDispatcher(){

            @Override
            public String receiveCommand(String cmd, Map<String, String> args) {
                return LWSManagerImpl.this.dispatch(cmd, args);
            }
        });
        StringBuffer hostNameAndPortBuffer = new StringBuffer(host);
        if (port > 0) {
            hostNameAndPortBuffer.append(":").append(port);
        }
        this.hostNameAndPort = hostNameAndPortBuffer.toString();
        this.dispatcher.addConnectionListener(new LWSConnectionListener(){

            public void connectionChanged(boolean isConnected) {
                LWSManagerImpl.this.isConnected = isConnected;
            }
        });
        this.registerHandler("IsConnected", new LWSManagerCommandResponseHandlerWithCallback("IsConnected"){

            @Override
            protected String handleRest(Map<String, String> args) {
                return "ok";
            }
        });
    }

    @Override
    public final boolean addConnectionListener(LWSConnectionListener lis) {
        return this.dispatcher.addConnectionListener(lis);
    }

    @Override
    public final boolean removeConnectionListener(LWSConnectionListener lis) {
        return this.dispatcher.removeConnectionListener(lis);
    }

    @Override
    public final HttpRequestHandler getHandler() {
        return this.dispatcher;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public final boolean registerHandler(String cmd, LWSManagerCommandResponseHandler lis) {
        if (lis == null) {
            throw new NullPointerException("Handlers can't be null");
        }
        String hash = this.hash(cmd);
        this.commands2handlers.put(hash, lis);
        return true;
    }

    @Override
    public final boolean unregisterHandler(String cmd) {
        String hash = this.hash(cmd);
        return this.commands2handlers.remove(hash) != null;
    }

    @Override
    public final boolean registerListener(String cmd, LWSManager.Listener lis) {
        String hash = this.hash(cmd);
        List<LWSManager.Listener> lst = this.commands2listenerLists.get(hash);
        if (lst == null) {
            lst = new Vector<LWSManager.Listener>();
            this.commands2listenerLists.put(hash, lst);
        }
        boolean result = lst.contains(lis) ? false : lst.add(lis);
        return result;
    }

    @Override
    public final boolean unregisterListener(String cmd) {
        String hash = this.hash(cmd);
        boolean result = this.commands2listenerLists.remove(hash) != null;
        return result;
    }

    @Override
    public final void clearHandlersAndListeners() {
        this.commands2handlers.clear();
        this.commands2listenerLists.clear();
    }

    @Override
    public final void sendMessageToServer(String msg, Map<String, String> args, StringCallback cb) throws IOException {
        HttpGet get;
        String url = this.constructURL(msg, args);
        try {
            get = new HttpGet(url);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        if (get.getURI().getHost() == null) {
            throw new IOException("null host!");
        }
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        cb.process("ok");
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 1000);
        HttpConnectionParams.setSoTimeout(params, 1000);
        this.exe.execute(get, params, new HttpClientListener(){

            public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
                LWSManagerImpl.this.exe.releaseResources(response);
                return false;
            }

            public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
                LWSManagerImpl.this.exe.releaseResources(response);
                return false;
            }
        });
    }

    private String constructURL(String msg, Map<String, String> args) {
        StringBuffer url = new StringBuffer("http://").append(this.hostNameAndPort).append(COMMAND_PAGE_WITH_LEADING_AND_TRAILING_SLASHES);
        url.append(msg);
        for (Map.Entry<String, String> e : args.entrySet()) {
            url.append("/");
            url.append(e.getKey()).append("/").append(EncodingUtils.encode(e.getValue()));
        }
        return url.toString();
    }

    private String hash(String cmd) {
        return cmd.toLowerCase();
    }

    private String dispatch(String cmd, Map<String, String> args) {
        List<LWSManager.Listener> ls;
        String hash = this.hash(cmd);
        LWSManagerCommandResponseHandler h = this.commands2handlers.get(hash);
        String res = null;
        boolean handled = false;
        if (h != null) {
            handled = true;
            res = h.handle(args);
        }
        if ((ls = this.commands2listenerLists.get(hash)) != null && !ls.isEmpty()) {
            handled = true;
            for (LWSManager.Listener l : ls) {
                l.handle(args);
            }
        }
        if (!handled) {
            return null;
        }
        if (res == null) {
            return "OK";
        }
        return res;
    }
}

