/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.messagehandlers.RestrictedResponder;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.InspectionResponse;
import com.limegroup.gnutella.messages.vendor.InspectionResponseFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.collection.Periodic;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.SecureMessageVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionRequestHandler
extends RestrictedResponder {
    private final Provider<MessageRouter> router;
    private final InspectionResponseFactory factory;
    private final Periodic sender;
    private final List<InspectionResponse> queue = new LinkedList<InspectionResponse>();
    private ReplyHandler currentHandler;
    private int currentInterval;

    @Inject
    public InspectionRequestHandler(Provider<MessageRouter> router, NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory udpReplyHandlerFactory, UDPReplyHandlerCache udpReplyHandlerCache, InspectionResponseFactory factory, @Named(value="inspection") SecureMessageVerifier inspectionVerifier, @Named(value="messageExecutor") ExecutorService dispatch, @Named(value="backgroundExecutor") ScheduledExecutorService background, NetworkInstanceUtils networkInstanceUtils) {
        super(FilterSettings.INSPECTOR_IP_ADDRESSES, inspectionVerifier, MessageSettings.INSPECTION_VERSION, networkManager, simppManager, udpReplyHandlerFactory, udpReplyHandlerCache, dispatch, networkInstanceUtils);
        this.router = router;
        this.factory = factory;
        this.sender = new Periodic(new Runnable(){

            public void run() {
                InspectionRequestHandler.this.send();
            }
        }, background);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processAllowedMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        assert (msg instanceof InspectionRequest);
        InspectionRequest ir = (InspectionRequest)msg;
        InspectionResponse[] r = this.factory.createResponses(ir);
        if (r.length > 0 && r[0].shouldBeSent()) {
            handler.reply(r[0]);
        }
        this.router.get().forwardInspectionRequestToLeaves(ir);
        InspectionRequestHandler inspectionRequestHandler = this;
        synchronized (inspectionRequestHandler) {
            this.queue.clear();
            if (r.length < 2) {
                return;
            }
            for (int i = 1; i < r.length; ++i) {
                this.queue.add(r[i]);
            }
            this.currentHandler = handler;
            this.currentInterval = ir.getSendInterval();
        }
        this.sender.rescheduleIfSooner(this.currentInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() {
        int interval;
        InspectionResponse resp = null;
        ReplyHandler handler = null;
        InspectionRequestHandler inspectionRequestHandler = this;
        synchronized (inspectionRequestHandler) {
            if (!this.queue.isEmpty()) {
                resp = this.queue.remove(0);
                handler = this.currentHandler;
            }
            interval = this.currentInterval;
        }
        if (resp == null || handler == null) {
            this.sender.unschedule();
            return;
        }
        if (resp.shouldBeSent()) {
            handler.reply(resp);
        }
        this.sender.rescheduleIfLater(interval);
    }
}

