/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messagehandlers.OOBSecurityToken;
import com.limegroup.gnutella.messagehandlers.OOBSession;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

@Singleton
public class OOBHandler
implements MessageHandler,
Runnable {
    private static final Log LOG = LogFactory.getLog(OOBHandler.class);
    private final MessageRouter router;
    private final MACCalculatorRepositoryManager MACCalculatorRepositoryManager;
    private final ScheduledExecutorService executor;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Map<Integer, OOBSession> OOBSessions = Collections.synchronizedMap(new HashMap());

    @Inject
    public OOBHandler(MessageRouter router, MACCalculatorRepositoryManager MACCalculatorRepositoryManager2, @Named(value="backgroundExecutor") ScheduledExecutorService executor, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.router = router;
        this.MACCalculatorRepositoryManager = MACCalculatorRepositoryManager2;
        this.executor = executor;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        if (msg instanceof ReplyNumberVendorMessage) {
            this.handleRNVM((ReplyNumberVendorMessage)msg, handler);
        } else if (msg instanceof QueryReply) {
            this.handleOOBReply((QueryReply)msg, handler);
        } else {
            throw new IllegalArgumentException("can't handle this type of message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRNVM(ReplyNumberVendorMessage msg, final ReplyHandler handler) {
        int toRequest;
        GUID g = new GUID(msg.getGUID());
        if (!this.router.isQueryAlive(g) || (toRequest = this.router.getNumOOBToRequest(msg)) <= 0) {
            this.router.addBypassedSource(msg, handler);
            this.outOfBandStatistics.addBypassedResponse(msg.getNumResults());
            return;
        }
        LimeACKVendorMessage ack = null;
        if (msg.isOOBv3()) {
            OOBSecurityToken t = new OOBSecurityToken(new OOBSecurityToken.OOBTokenData(handler, msg.getGUID(), toRequest), this.MACCalculatorRepositoryManager);
            int hash = Arrays.hashCode(t.getBytes());
            Map<Integer, OOBSession> map = this.OOBSessions;
            synchronized (map) {
                if (!this.OOBSessions.containsKey(hash)) {
                    this.OOBSessions.put(hash, new OOBSession(t, toRequest, new GUID(msg.getGUID()), true));
                    ack = new LimeACKVendorMessage(g, toRequest, t);
                }
            }
        } else {
            ack = new LimeACKVendorMessage(g, toRequest);
        }
        if (ack != null) {
            this.outOfBandStatistics.addRequestedResponse(toRequest);
            handler.reply(ack);
            if (MessageSettings.OOB_REDUNDANCY.getValue()) {
                final LimeACKVendorMessage ackf = ack;
                this.executor.schedule(new Runnable(){

                    public void run() {
                        handler.reply(ackf);
                    }
                }, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOOBReply(QueryReply reply, ReplyHandler handler) {
        SecurityToken token;
        byte[] handlerAddress;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Handling reply: " + reply + ", from: " + handler);
        }
        if (!Arrays.equals(handlerAddress = handler.getInetAddress().getAddress(), reply.getIPBytes())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("IP addresses of sender and packet did not match, sender: " + handler.getInetAddress() + ", packet: " + reply.getIP());
            }
            try {
                if (reply.getNeedsPush() || !this.networkInstanceUtils.isPrivateAddress(reply.getIPBytes())) {
                    reply.setOOBAddress(handler.getInetAddress(), handler.getPort());
                }
            }
            catch (BadPacketException bpe) {
                return;
            }
        }
        if ((token = this.getVerifiedSecurityToken(reply, handler)) == null) {
            if (!SearchSettings.DISABLE_OOB_V2.getBoolean()) {
                this.router.handleQueryReply(reply, handler);
            }
            return;
        }
        short numResps = reply.getResultCount();
        this.outOfBandStatistics.addReceivedResponse(numResps);
        int requestedResponseCount = token.getBytes()[0] & 0xFF;
        boolean shouldAddBypassedSource = false;
        GUID queryGUID = new GUID(reply.getGUID());
        if (!this.router.isQueryAlive(queryGUID)) {
            shouldAddBypassedSource = true;
        } else {
            Map<Integer, OOBSession> map = this.OOBSessions;
            synchronized (map) {
                int remainingCount;
                int hashKey = Arrays.hashCode(token.getBytes());
                OOBSession session = this.OOBSessions.get(hashKey);
                if (session == null) {
                    session = new OOBSession(token, requestedResponseCount, queryGUID, false);
                    this.OOBSessions.put(hashKey, session);
                }
                if ((remainingCount = session.getRemainingResultsCount() - numResps) >= 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Requested >= than got (" + remainingCount + " left over)");
                    }
                    try {
                        int added = session.countAddedResponses(reply.getResultsArray());
                        if (added > 0) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Handling the reply.");
                            }
                            this.router.handleQueryReply(reply, handler);
                        }
                    }
                    catch (BadPacketException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (shouldAddBypassedSource) {
            this.router.addBypassedSource(reply, handler);
        }
    }

    private SecurityToken getVerifiedSecurityToken(QueryReply reply, ReplyHandler handler) {
        byte[] securityBytes = reply.getSecurityToken();
        if (securityBytes == null) {
            return null;
        }
        try {
            OOBSecurityToken oobKey = new OOBSecurityToken(securityBytes, this.MACCalculatorRepositoryManager);
            OOBSecurityToken.OOBTokenData data = new OOBSecurityToken.OOBTokenData(handler, reply.getGUID(), securityBytes[0] & 0xFF);
            if (oobKey.isFor(data)) {
                return oobKey;
            }
        }
        catch (InvalidSecurityTokenException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expire() {
        Map<Integer, OOBSession> map = this.OOBSessions;
        synchronized (map) {
            Iterator<Map.Entry<Integer, OOBSession>> iter = this.OOBSessions.entrySet().iterator();
            while (iter.hasNext()) {
                if (this.router.isQueryAlive(iter.next().getValue().getGUID())) continue;
                iter.remove();
            }
        }
    }

    public void run() {
        this.expire();
    }

    @InspectableContainer
    private class OOBInspectable {
        @InspectionPoint(value="oob sessions")
        public final Inspectable oobSessions = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                ArrayList<Object> list;
                Map map = OOBHandler.this.OOBSessions;
                synchronized (map) {
                    list = new ArrayList<Object>(OOBHandler.this.OOBSessions.size());
                    for (OOBSession o : OOBHandler.this.OOBSessions.values()) {
                        list.add(o.inspect());
                    }
                }
                return list;
            }
        };

        private OOBInspectable() {
        }
    }
}

