/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.limegroup.gnutella.ReplyHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.limewire.io.NetworkUtils;
import org.limewire.security.AbstractSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;

public class OOBSecurityToken
extends AbstractSecurityToken {
    public OOBSecurityToken(OOBTokenData data, MACCalculatorRepositoryManager manager) {
        super(data, manager);
    }

    public OOBSecurityToken(byte[] network, MACCalculatorRepositoryManager manager) throws InvalidSecurityTokenException {
        super(network, manager);
    }

    protected byte[] getFromMAC(byte[] b, SecurityToken.TokenData data) {
        byte[] ret = new byte[b.length + 1];
        ret[0] = (byte)((OOBTokenData)data).getNumRequests();
        System.arraycopy(b, 0, ret, 1, b.length);
        return ret;
    }

    protected boolean isValidTokenData(SecurityToken.TokenData data) {
        return data instanceof OOBTokenData;
    }

    public static class OOBTokenData
    implements SecurityToken.TokenData {
        private final int numRequests;
        private final byte[] data;

        public OOBTokenData(ReplyHandler replyHandler, byte[] guid, int numRequests) {
            this(replyHandler.getInetAddress(), replyHandler.getPort(), guid, numRequests);
        }

        public OOBTokenData(InetAddress address, int port, byte[] guid, int numRequests) {
            if (numRequests < 0 || numRequests > 255) {
                throw new IllegalArgumentException("requestNum to small or too large " + numRequests);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(35);
            DataOutputStream data = new DataOutputStream(baos);
            try {
                data.writeShort(port);
                if (NetworkUtils.isIPv6Compatible(address)) {
                    data.write(NetworkUtils.getIPv6AddressBytes(address));
                } else {
                    data.write(address.getAddress());
                }
                data.write(numRequests);
                data.write(guid);
            }
            catch (IOException ie) {
                ErrorService.error(ie);
            }
            this.data = baos.toByteArray();
            this.numRequests = numRequests;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getNumRequests() {
            return this.numRequests;
        }
    }
}

