/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.limewire.collection.IntSet;
import org.limewire.inspection.Inspectable;
import org.limewire.security.SecurityToken;

class OOBSession
implements Inspectable {
    private final List<Long> responseTimestamps = new ArrayList<Long>(10);
    private final List<Integer> responseCounts = new ArrayList<Integer>(10);
    private final List<Integer> addedResponses = new ArrayList<Integer>(10);
    private final long start;
    private final boolean early;
    private final SecurityToken token;
    private final IntSet urnHashCodes;
    private IntSet responseHashCodes;
    private final int requestedResponseCount;
    private final GUID guid;

    OOBSession(SecurityToken token, int requestedResponseCount, GUID guid, boolean early) {
        this.token = token;
        this.requestedResponseCount = requestedResponseCount;
        this.urnHashCodes = new IntSet(requestedResponseCount);
        this.guid = guid;
        this.early = early;
        this.start = System.currentTimeMillis();
    }

    GUID getGUID() {
        return this.guid;
    }

    int countAddedResponses(Response[] responses) {
        int added = 0;
        for (Response response : responses) {
            Set<URN> urns = response.getUrns();
            if (!urns.isEmpty()) {
                added += this.urnHashCodes.add(urns.iterator().next().hashCode()) ? 1 : 0;
                continue;
            }
            if (this.responseHashCodes == null) {
                this.responseHashCodes = new IntSet();
            }
            added += this.responseHashCodes.add(response.hashCode()) ? 1 : 0;
        }
        this.responseTimestamps.add(System.currentTimeMillis());
        this.responseCounts.add(responses.length);
        this.addedResponses.add(added);
        return added;
    }

    final int getRemainingResultsCount() {
        return this.requestedResponseCount - this.urnHashCodes.size() - (this.responseHashCodes != null ? this.responseHashCodes.size() : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OOBSession)) {
            return false;
        }
        OOBSession other = (OOBSession)o;
        return Arrays.equals(this.token.getBytes(), other.token.getBytes());
    }

    public Object inspect() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("start", this.start);
        ret.put("urnh", this.urnHashCodes.size());
        if (this.responseHashCodes != null) {
            ret.put("rhh", this.responseHashCodes.size());
        }
        ret.put("rrc", this.requestedResponseCount);
        ret.put("timestamps", this.responseTimestamps);
        ret.put("rcounts", this.responseCounts);
        ret.put("added", this.addedResponses);
        ret.put("early", this.early);
        return ret;
    }
}

