/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.RoutableGGEPMessage;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.setting.LongSetting;
import org.limewire.setting.StringArraySetting;

abstract class RestrictedResponder
implements SimppListener,
MessageHandler {
    private volatile IPList allowed;
    private final StringArraySetting setting;
    private final SecureMessageVerifier verifier;
    private final LongSetting lastRoutedVersion;
    private final NetworkManager networkManager;
    private final UDPReplyHandlerFactory udpReplyHandlerFactory;
    private final UDPReplyHandlerCache udpReplyHandlerCache;
    private final Executor messageExecutorService;
    private final NetworkInstanceUtils networkInstanceUtils;

    public RestrictedResponder(StringArraySetting setting, NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory udpReplyHandlerFactory, UDPReplyHandlerCache udpReplyHandlerCache, Executor messageExecutor, NetworkInstanceUtils networkInstanceUtils) {
        this(setting, null, null, networkManager, simppManager, udpReplyHandlerFactory, udpReplyHandlerCache, messageExecutor, networkInstanceUtils);
    }

    public RestrictedResponder(StringArraySetting setting, SecureMessageVerifier verifier, LongSetting lastRoutedVersion, NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory udpReplyHandlerFactory, UDPReplyHandlerCache udpReplyHandlerCache, Executor messageExecutorService, NetworkInstanceUtils networkInstanceUtils) {
        this.setting = setting;
        this.verifier = verifier;
        this.lastRoutedVersion = lastRoutedVersion;
        this.networkManager = networkManager;
        this.udpReplyHandlerFactory = udpReplyHandlerFactory;
        this.udpReplyHandlerCache = udpReplyHandlerCache;
        this.messageExecutorService = messageExecutorService;
        this.networkInstanceUtils = networkInstanceUtils;
        this.allowed = new IPList();
        this.allowed.add("*.*.*.*");
        simppManager.addListener(this);
        this.updateAllowed();
    }

    private void updateAllowed() {
        IPList newCrawlers = new IPList();
        try {
            for (String ip : this.setting.getValue()) {
                newCrawlers.add(new IP(ip));
            }
            if (newCrawlers.isValidFilter(false, this.networkInstanceUtils)) {
                this.allowed = newCrawlers;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void simppUpdated(int newVersion) {
        this.updateAllowed();
    }

    public final void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        System.out.print("Handling message: " + msg);
        if (msg instanceof RoutableGGEPMessage) {
            if (this.verifier != null && msg instanceof SecureMessage) {
                this.verifier.verify((SecureMessage)((Object)msg), new SecureCallback(addr, handler));
            } else {
                this.processRoutableMessage((RoutableGGEPMessage)msg, addr, handler);
            }
        } else {
            if (!this.allowed.contains(new IP(handler.getAddress()))) {
                return;
            }
            this.processAllowedMessage(msg, addr, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRoutableMessage(RoutableGGEPMessage msg, InetSocketAddress addr, ReplyHandler handler) {
        if (msg.getReturnAddress() != null) {
            if (msg.getRoutableVersion() < 0L) {
                return;
            }
            handler = this.udpReplyHandlerFactory.createUDPReplyHandler(msg.getReturnAddress().getInetAddress(), msg.getReturnAddress().getPort(), this.udpReplyHandlerCache.getPersonalFilter());
        } else if (msg.getDestinationAddress() != null ? !Arrays.equals(this.networkManager.getExternalAddress(), msg.getDestinationAddress().getInetAddress().getAddress()) : msg.getRoutableVersion() < 0L) {
            return;
        }
        if (!this.allowed.contains(new IP(handler.getAddress()))) {
            return;
        }
        long routableVersion = msg.getRoutableVersion();
        if (this.lastRoutedVersion != null && routableVersion > 0L) {
            LongSetting longSetting = this.lastRoutedVersion;
            synchronized (longSetting) {
                if (routableVersion <= this.lastRoutedVersion.getValue()) {
                    return;
                }
                this.lastRoutedVersion.setValue(routableVersion);
            }
        }
        this.processAllowedMessage(msg, addr, handler);
    }

    protected abstract void processAllowedMessage(Message var1, InetSocketAddress var2, ReplyHandler var3);

    private class SecureCallback
    implements SecureMessageCallback {
        private final InetSocketAddress addr;
        private final ReplyHandler handler;

        SecureCallback(InetSocketAddress addr, ReplyHandler handler) {
            this.addr = addr;
            this.handler = handler;
        }

        public void handleSecureMessage(final SecureMessage sm, boolean passed) {
            if (!passed) {
                return;
            }
            RestrictedResponder.this.messageExecutorService.execute(new Runnable(){

                public void run() {
                    RestrictedResponder.this.processRoutableMessage((RoutableGGEPMessage)sm, SecureCallback.this.addr, SecureCallback.this.handler);
                }
            });
        }
    }
}

