/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.messagehandlers.RestrictedResponder;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPongFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.io.NetworkInstanceUtils;

public class UDPCrawlerPingHandler
extends RestrictedResponder {
    private FixedSizeExpiringSet<InetAddress> _UDPListRequestors = new FixedSizeExpiringSet(2000, 600000L);
    private final UDPCrawlerPongFactory udpCrawlerPongFactory;

    @Inject
    public UDPCrawlerPingHandler(NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory udpReplyHandlerFactory, UDPReplyHandlerCache udpReplyHandlerCache, UDPCrawlerPongFactory udpCrawlerPongFactory, NetworkInstanceUtils networkInstanceUtils) {
        super(FilterSettings.CRAWLER_IP_ADDRESSES, networkManager, simppManager, udpReplyHandlerFactory, udpReplyHandlerCache, null, networkInstanceUtils);
        this.udpCrawlerPongFactory = udpCrawlerPongFactory;
    }

    protected void processAllowedMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        assert (msg instanceof UDPCrawlerPing);
        if (!this._UDPListRequestors.add(handler.getInetAddress())) {
            return;
        }
        UDPCrawlerPong pong = this.udpCrawlerPongFactory.createUDPCrawlerPong((UDPCrawlerPing)msg);
        handler.reply(pong);
    }
}

