/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.util.COBSUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.limewire.collection.NameValue;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGEP {
    public static final String GGEP_HEADER_BROWSE_HOST = "BH";
    public static final String GGEP_HEADER_DAILY_AVERAGE_UPTIME = "DU";
    public static final String GGEP_HEADER_UNICAST_SUPPORT = "GUE";
    public static final String GGEP_HEADER_UP_SUPPORT = "UP";
    public static final String GGEP_HEADER_QUERY_KEY_SUPPORT = "QK";
    public static final String GGEP_HEADER_SECURE_OOB = "SO";
    public static final String GGEP_HEADER_MULTICAST_RESPONSE = "MCAST";
    public static final String GGEP_HEADER_PUSH_PROXY = "PUSH";
    public static final String GGEP_HEADER_PUSH_PROXY_TLS = "PUSH_TLS";
    public static final String GGEP_HEADER_ALTS = "ALT";
    public static final String GGEP_HEADER_ALTS_TLS = "ALT_TLS";
    public static final String GGEP_HEADER_IPPORT = "IP";
    public static final String GGEP_HEADER_UDP_HOST_CACHE = "UDPHC";
    public static final String GGEP_HEADER_SUPPORT_CACHE_PONGS = "SCP";
    public static final String GGEP_HEADER_PACKED_IPPORTS = "IPP";
    public static final String GGEP_HEADER_PACKED_IPPORTS_TLS = "IPP_TLS";
    public static final String GGEP_HEADER_TLS_CAPABLE = "TLS";
    public static final String GGEP_HEADER_PACKED_HOSTCACHES = "PHC";
    public static final String GGEP_HEADER_SHA1 = "S1";
    public static final String GGEP_HEADER_TTROOT = "TT";
    public static final String GGEP_HEADER_SHA1_VALID = "SV";
    public static final String GGEP_HEADER_DHT_SUPPORT = "DHT";
    public static final String GGEP_HEADER_DHT_IPPORTS = "DHTIPP";
    public static final String GGEP_HEADER_FEATURE_QUERY = "WH";
    public static final String GGEP_HEADER_NO_PROXY = "NP";
    public static final String GGEP_HEADER_META = "M";
    public static final String GGEP_HEADER_CLIENT_LOCALE = "LOC";
    public static final String GGEP_HEADER_CREATE_TIME = "CT";
    public static final String GGEP_HEADER_FW_TRANS = "FW";
    public static final String GGEP_HEADER_SECURE_BLOCK = "SB";
    public static final String GGEP_HEADER_SIGNATURE = "SIG";
    public static final String GGEP_HEADER_LARGE_FILE = "LF";
    public static final String GGEP_HEADER_PARTIAL_RESULT_PREFIX = "PR";
    public static final String GGEP_HEADER_PARTIAL_RESULT_UNVERIFIED = "PRU";
    public static final String GGEP_HEADER_RETURN_PATH_SOURCE = "RPS";
    public static final String GGEP_HEADER_RETURN_PATH_HOPS = "RPH";
    public static final String GGEP_HEADER_RETURN_PATH_ME = "RPI";
    public static final String GGEP_HEADER_RETURN_PATH_TTL = "RPT";
    public static final int MAX_KEY_SIZE_IN_BYTES = 15;
    public static final int MAX_VALUE_SIZE_IN_BYTES = 262143;
    public static final byte GGEP_PREFIX_MAGIC_NUMBER = -61;
    private final Map<String, Object> _props = new TreeMap<String, Object>();
    public final boolean useCOBS;
    private volatile int hashCode = 0;

    public GGEP(boolean useCOBS) {
        this.useCOBS = useCOBS;
    }

    public GGEP() {
        this(false);
    }

    public GGEP(byte[] data, int offset) throws BadGGEPBlockException {
        this(data, offset, null);
    }

    public GGEP(byte[] messageBytes, int beginOffset, int[] endOffset) throws BadGGEPBlockException {
        if (messageBytes.length - beginOffset < 4) {
            throw new BadGGEPBlockException();
        }
        if (messageBytes[beginOffset] != -61) {
            throw new BadGGEPBlockException();
        }
        boolean tUseCOBS = false;
        boolean onLastExtension = false;
        int currIndex = beginOffset + 1;
        while (!onLastExtension) {
            try {
                this.sanityCheck(messageBytes[currIndex]);
            }
            catch (ArrayIndexOutOfBoundsException malformedInput) {
                throw new BadGGEPBlockException();
            }
            onLastExtension = this.isLastExtension(messageBytes[currIndex]);
            boolean encoded = this.isEncoded(messageBytes[currIndex]);
            boolean compressed = this.isCompressed(messageBytes[currIndex]);
            int headerLen = this.deriveHeaderLength(messageBytes[currIndex]);
            ++currIndex;
            String extensionHeader = null;
            try {
                extensionHeader = new String(messageBytes, currIndex, headerLen);
            }
            catch (StringIndexOutOfBoundsException inputIsMalformed) {
                throw new BadGGEPBlockException();
            }
            int[] toIncrement = new int[1];
            int dataLength = this.deriveDataLength(messageBytes, currIndex += headerLen, toIncrement);
            byte[] extensionData = null;
            currIndex += toIncrement[0];
            if (dataLength > 0) {
                byte[] data = new byte[dataLength];
                try {
                    System.arraycopy(messageBytes, currIndex, data, 0, dataLength);
                }
                catch (ArrayIndexOutOfBoundsException malformedInput) {
                    throw new BadGGEPBlockException();
                }
                if (encoded) {
                    tUseCOBS = true;
                    try {
                        data = COBSUtil.cobsDecode(data);
                    }
                    catch (IOException badCobsEncoding) {
                        throw new BadGGEPBlockException("Bad COBS Encoding");
                    }
                }
                if (compressed) {
                    try {
                        data = IOUtils.inflate(data);
                    }
                    catch (IOException badData) {
                        throw new BadGGEPBlockException("Bad compressed data");
                    }
                }
                extensionData = data;
                currIndex += dataLength;
            }
            if (compressed) {
                this._props.put(extensionHeader, new NeedsCompression(extensionData));
                continue;
            }
            this._props.put(extensionHeader, extensionData);
        }
        if (endOffset != null && endOffset.length > 0) {
            endOffset[0] = currIndex;
        }
        this.useCOBS = tUseCOBS;
    }

    public void merge(GGEP other) {
        this._props.putAll(other._props);
    }

    private void sanityCheck(byte headerFlags) throws BadGGEPBlockException {
        if ((headerFlags & 0x10) != 0) {
            throw new BadGGEPBlockException();
        }
    }

    private boolean isLastExtension(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x80) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private boolean isEncoded(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x40) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private boolean isCompressed(byte headerFlags) {
        boolean retBool = false;
        if ((headerFlags & 0x20) != 0) {
            retBool = true;
        }
        return retBool;
    }

    private int deriveHeaderLength(byte headerFlags) throws BadGGEPBlockException {
        int retInt = 0;
        retInt = headerFlags & 0xF;
        if (retInt == 0) {
            throw new BadGGEPBlockException();
        }
        return retInt;
    }

    private int deriveDataLength(byte[] buff, int beginOffset, int[] increment) throws BadGGEPBlockException {
        byte currByte;
        int length = 0;
        int iterations = 0;
        int MAX_ITERATIONS = 3;
        do {
            try {
                currByte = buff[beginOffset++];
            }
            catch (ArrayIndexOutOfBoundsException malformedInput) {
                throw new BadGGEPBlockException();
            }
            length = length << 6 | currByte & 0x3F;
            if (++iterations <= 3) continue;
            throw new BadGGEPBlockException();
        } while (64 != (currByte & 0x40));
        increment[0] = iterations;
        return length;
    }

    public void write(OutputStream out) throws IOException {
        if (this.getHeaders().size() > 0) {
            out.write(-61);
            Iterator<String> headers = this.getHeaders().iterator();
            while (headers.hasNext()) {
                String currHeader = headers.next();
                byte[] currData = this.get(currHeader);
                int dataLen = 0;
                boolean shouldEncode = this.shouldCOBSEncode(currData);
                boolean shouldCompress = this.shouldCompress(currHeader);
                if (currData != null) {
                    if (shouldCompress && (currData = IOUtils.deflate(currData)).length > 262143) {
                        throw new IllegalArgumentException("value for [" + currHeader + "] too large after compression");
                    }
                    if (shouldEncode) {
                        currData = COBSUtil.cobsEncode(currData);
                    }
                    dataLen = currData.length;
                }
                this.writeHeader(currHeader, dataLen, !headers.hasNext(), out, shouldEncode, shouldCompress);
                if (dataLen <= 0) continue;
                out.write(currData);
            }
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
        return out.toByteArray();
    }

    private final boolean shouldCOBSEncode(byte[] data) {
        return this.useCOBS && this.containsNull(data);
    }

    private final boolean shouldCompress(String header) {
        return this._props.get(header) instanceof NeedsCompression;
    }

    private void writeHeader(String header, int dataLen, boolean isLast, OutputStream out, boolean isEncoded, boolean isCompressed) throws IOException {
        int toWrite;
        int flags = 0;
        if (isLast) {
            flags |= 0x80;
        }
        if (isEncoded) {
            flags |= 0x40;
        }
        if (isCompressed) {
            flags |= 0x20;
        }
        out.write(flags |= header.getBytes().length);
        out.write(header.getBytes());
        int begin = dataLen & 0x3F000;
        if (dataLen > 4095) {
            toWrite = 0x80 | (begin >>= 12);
            out.write(toWrite);
        }
        int middle = dataLen & 0xFC0;
        if (dataLen > 63) {
            toWrite = 0x80 | (middle >>= 6);
            out.write(toWrite);
        }
        int end = dataLen & 0x3F;
        toWrite = 0x40 | end;
        out.write(toWrite);
    }

    public int getHeaderOverhead(String key) {
        byte[] data = this.get(key);
        if (data == null) {
            throw new IllegalArgumentException("no data for key: " + key);
        }
        return 1 + key.length() + data.length + 1 + (data.length > 63 ? 1 : 0) + (data.length > 4095 ? 1 : 0);
    }

    public void putAll(List<? extends NameValue<?>> fields) throws IllegalArgumentException {
        for (NameValue<?> next : fields) {
            String key = next.getName();
            Object value = next.getValue();
            if (value == null) {
                this.put(key);
                continue;
            }
            if (value instanceof byte[]) {
                this.put(key, (byte[])value);
                continue;
            }
            if (value instanceof String) {
                this.put(key, (String)value);
                continue;
            }
            if (value instanceof Integer) {
                this.put(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.put(key, (Long)value);
                continue;
            }
            if (value instanceof Byte) {
                this.put(key, (Byte)value);
                continue;
            }
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }

    public void putCompressed(String key, byte[] value) throws IllegalArgumentException {
        this.validateKey(key);
        this._props.put(key, new NeedsCompression(value));
    }

    public void put(String key, byte value) throws IllegalArgumentException {
        this.put(key, new byte[]{value});
    }

    public void put(String key, byte[] value) throws IllegalArgumentException {
        this.validateKey(key);
        this.validateValue(value);
        this._props.put(key, value);
    }

    public void put(String key, String value) throws IllegalArgumentException {
        this.put(key, value == null ? null : value.getBytes());
    }

    public void put(String key, int value) throws IllegalArgumentException {
        if (value < 0) {
            throw new IllegalArgumentException("Negative value");
        }
        this.put(key, ByteOrder.int2minLeb(value));
    }

    public void put(String key, long value) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value");
        }
        this.put(key, ByteOrder.long2minLeb(value));
    }

    public void put(String key) throws IllegalArgumentException {
        this.put(key, (byte[])null);
    }

    public byte[] getBytes(String key) throws BadGGEPPropertyException {
        byte[] ret = this.get(key);
        if (ret == null) {
            throw new BadGGEPPropertyException();
        }
        return ret;
    }

    public String getString(String key) throws BadGGEPPropertyException {
        return new String(this.getBytes(key));
    }

    public int getInt(String key) throws BadGGEPPropertyException {
        byte[] bytes = this.getBytes(key);
        if (bytes.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (bytes.length > 4) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteOrder.leb2int(bytes, 0, bytes.length);
    }

    public long getLong(String key) throws BadGGEPPropertyException {
        byte[] bytes = this.getBytes(key);
        if (bytes.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (bytes.length > 8) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteOrder.leb2long(bytes, 0, bytes.length);
    }

    public boolean hasKey(String key) {
        return this._props.containsKey(key);
    }

    public Set<String> getHeaders() {
        return this._props.keySet();
    }

    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    public byte[] get(String key) {
        Object value = this._props.get(key);
        if (value instanceof NeedsCompression) {
            return ((NeedsCompression)value).data;
        }
        return (byte[])value;
    }

    private void validateKey(String key) throws IllegalArgumentException {
        byte[] bytes = key.getBytes();
        if (key.equals("") || bytes.length > 15 || this.containsNull(bytes)) {
            throw new IllegalArgumentException();
        }
    }

    private void validateValue(byte[] value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        if (value.length > 262143) {
            throw new IllegalArgumentException();
        }
    }

    private boolean containsNull(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GGEP)) {
            return false;
        }
        return this.subset((GGEP)o) && ((GGEP)o).subset(this);
    }

    private boolean subset(GGEP other) {
        for (String key : this._props.keySet()) {
            byte[] v2;
            byte[] v1 = this.get(key);
            if (v1 == null != ((v2 = other.get(key)) == null)) {
                return false;
            }
            if (v1 == null || Arrays.equals(v1, v2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * ((Object)this._props).hashCode();
        }
        return this.hashCode;
    }

    private static class NeedsCompression {
        final byte[] data;

        NeedsCompression(byte[] data) {
            this.data = data;
        }
    }
}

