/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.limewire.collection.Buffer;
import org.limewire.inspection.Inspectable;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Message
extends Comparable<Message> {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    public static final byte F_ROUTE_TABLE_UPDATE = 48;
    public static final byte F_VENDOR_MESSAGE = 49;
    public static final byte F_VENDOR_MESSAGE_STABLE = 50;
    public static final byte F_UDP_CONNECTION = 65;

    public void writeQuickly(OutputStream var1) throws IOException;

    public void write(OutputStream var1, byte[] var2) throws IOException;

    public void write(OutputStream var1) throws IOException;

    public Network getNetwork();

    public boolean isMulticast();

    public boolean isUDP();

    public boolean isTCP();

    public boolean isUnknownNetwork();

    public byte[] getGUID();

    public byte getFunc();

    public byte getTTL();

    public void setTTL(byte var1) throws IllegalArgumentException;

    public void setHops(byte var1) throws IllegalArgumentException;

    public byte getHops();

    public int getLength();

    public int getTotalLength();

    public byte hop();

    public long getCreationTime();

    public int getPriority();

    public void setPriority(int var1);

    public Class<? extends Message> getHandlerClass();

    public static class MessageCounter
    implements Inspectable {
        private final int history;
        private Map<Class, EnumMap<Network, MessageTypeCounter>> counts = new HashMap<Class, EnumMap<Network, MessageTypeCounter>>();

        public MessageCounter(int history) {
            this.history = history;
        }

        public synchronized void countMessage(Message msg) {
            MessageTypeCounter count;
            EnumMap<Network, MessageTypeCounter> m = this.counts.get(msg.getClass());
            if (m == null) {
                m = new EnumMap(Network.class);
                this.counts.put(msg.getClass(), m);
            }
            if ((count = m.get((Object)msg.getNetwork())) == null) {
                count = new MessageTypeCounter(msg.getClass(), msg.getNetwork(), this.history);
                m.put(msg.getNetwork(), count);
            }
            count.countMessage(msg);
        }

        public synchronized Object inspect() {
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(this.counts.size());
            for (EnumMap<Network, MessageTypeCounter> e : this.counts.values()) {
                for (MessageTypeCounter mtc : e.values()) {
                    ret.add(mtc.inspect());
                }
            }
            return ret;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class MessageTypeCounter {
            private final Class clazz;
            private final Network net;
            private long num;
            private long size;
            private Buffer<Long> timestamps;
            private Buffer<Integer> sizes;
            private Buffer<Byte> hops;
            private Buffer<Byte> ttls;

            MessageTypeCounter(Class<? extends Message> clazz, Network net, int history) {
                this.clazz = clazz;
                this.net = net;
                this.timestamps = new Buffer(history);
                this.sizes = new Buffer(history);
                this.hops = new Buffer(history);
                this.ttls = new Buffer(history);
            }

            void countMessage(Message m) {
                ++this.num;
                this.size += (long)m.getLength();
                this.timestamps.add(System.currentTimeMillis());
                this.sizes.add(m.getLength());
                this.hops.add(m.getHops());
                this.ttls.add(m.getTTL());
            }

            Map<String, Object> inspect() {
                int i;
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("class", this.clazz.toString());
                ret.put("net", this.net.toString());
                ret.put("num", this.num);
                ret.put("size", this.size);
                byte[] timesByte = new byte[this.timestamps.getSize() * 6];
                byte[] sizesByte = new byte[this.sizes.getSize() * 2];
                byte[] hopsByte = new byte[this.hops.getSize()];
                byte[] ttlsByte = new byte[this.ttls.getSize()];
                for (i = 0; i < this.timestamps.getSize(); ++i) {
                    long timestamp = this.timestamps.get(i);
                    timesByte[i * 6] = (byte)(timestamp >> 40 & 0xFFL);
                    timesByte[i * 6 + 1] = (byte)(timestamp >> 32 & 0xFFL);
                    ByteOrder.int2beb((int)timestamp, timesByte, i * 6 + 2);
                }
                for (i = 0; i < this.sizes.getSize(); ++i) {
                    short size = (short)Math.min(65535, this.sizes.get(i));
                    ByteOrder.short2beb(size, sizesByte, i * 2);
                }
                for (i = 0; i < this.hops.getSize(); ++i) {
                    hopsByte[i] = this.hops.get(i);
                }
                for (i = 0; i < this.ttls.getSize(); ++i) {
                    ttlsByte[i] = this.ttls.get(i);
                }
                ret.put("times", timesByte);
                ret.put("sizes", sizesByte);
                ret.put("hops", hopsByte);
                ret.put("ttls", ttlsByte);
                return ret;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Network {
        UNKNOWN,
        TCP,
        UDP,
        MULTICAST;

    }
}

