/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.MessageParserBinder;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.util.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.ByteOrder;

@Singleton
public class MessageFactoryImpl
implements MessageFactory {
    private static final Log LOG = LogFactory.getLog(MessageFactoryImpl.class);
    private final MessageFactory.MessageParser[] PARSERS = new MessageFactory.MessageParser[256];
    private final byte defaultSoftMax = ConnectionSettings.SOFT_MAX.getValue();

    public MessageFactoryImpl() {
    }

    @Inject
    public MessageFactoryImpl(MessageParserBinder messageParserBinder) {
        messageParserBinder.bind(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParser(byte functionId, MessageFactory.MessageParser parser) {
        if (parser == null) {
            throw new NullPointerException("MessageParser is null");
        }
        int index = functionId & 0xFF;
        MessageFactory.MessageParser o = null;
        MessageFactory.MessageParser[] messageParserArray = this.PARSERS;
        synchronized (this.PARSERS) {
            o = this.PARSERS[index];
            this.PARSERS[index] = parser;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (o != null && LOG.isErrorEnabled()) {
                LOG.error("There was already a MessageParser of type " + o.getClass() + " registered for functionId " + functionId);
            }
            return;
        }
    }

    public MessageFactory.MessageParser getParser(byte functionId) {
        return this.PARSERS[functionId & 0xFF];
    }

    public Message read(InputStream in, Message.Network network) throws BadPacketException, IOException {
        return this.read(in, network, new byte[23], this.defaultSoftMax, null);
    }

    public Message read(InputStream in, Message.Network network, byte softMax) throws BadPacketException, IOException {
        return this.read(in, network, new byte[23], softMax, null);
    }

    public Message read(InputStream in, Message.Network network, byte[] buf, byte softMax) throws BadPacketException, IOException {
        return this.read(in, network, buf, softMax, null);
    }

    public Message read(InputStream in, Message.Network network, byte[] buf, SocketAddress addr) throws BadPacketException, IOException {
        return this.read(in, network, buf, this.defaultSoftMax, addr);
    }

    public Message read(InputStream in, Message.Network network, byte[] buf, byte softMax, SocketAddress addr) throws BadPacketException, IOException {
        int got;
        for (int i = 0; i < 23; i += got) {
            try {
                got = in.read(buf, i, 23 - i);
            }
            catch (InterruptedIOException e) {
                if (i == 0) {
                    return null;
                }
                throw e;
            }
            if (got != -1) continue;
            throw new IOException("Connection closed.");
        }
        int length = ByteOrder.leb2int(buf, 19);
        if (length < 0 || length > MessageSettings.MAX_LENGTH.getValue()) {
            throw new IOException("Unreasonable message length: " + length);
        }
        byte[] payload = null;
        if (length != 0) {
            int got2;
            payload = new byte[length];
            for (int i = 0; i < length; i += got2) {
                got2 = in.read(payload, i, length - i);
                if (got2 != -1) continue;
                throw new IOException("Read EOF before EOM.");
            }
        } else {
            payload = DataUtils.EMPTY_BYTE_ARRAY;
        }
        return this.createMessage(buf, payload, network, softMax, addr);
    }

    public Message createMessage(byte[] header, byte[] payload, Message.Network network, byte softMax, SocketAddress addr) throws BadPacketException, IOException {
        if (header.length < 19) {
            throw new IllegalArgumentException("header must be >= 19 bytes.");
        }
        byte func = header[16];
        MessageFactory.MessageParser parser = this.getParser(func);
        if (parser == null) {
            throw new BadPacketException("Unrecognized function code: " + func);
        }
        return parser.parse(header, payload, network, softMax, addr);
    }
}

