/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.MessageParserBinder;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.routing.RouteTableMessage;
import java.io.IOException;
import java.net.SocketAddress;
import org.limewire.inspection.InspectablePrimitive;

@Singleton
public class MessageParserBinderImpl
implements MessageParserBinder {
    private final PingReplyFactory pingReplyFactory;
    private final QueryReplyFactory queryReplyFactory;
    private final QueryRequestFactory queryRequestFactory;
    private final VendorMessageFactory vendorMessageFactory;
    private final PingRequestFactory pingRequestFactory;
    @InspectablePrimitive(value="bad hops messages")
    private static volatile long badHops;
    @InspectablePrimitive(value="bad ttl messages")
    private static volatile long badTTL;
    @InspectablePrimitive(value="high hops messages")
    private static volatile long highHops;
    @InspectablePrimitive(value="adjusted ttl messages")
    private static volatile long adjustings;
    @InspectablePrimitive(value="parsed messages")
    private static volatile long parsings;

    @Inject
    public MessageParserBinderImpl(PingReplyFactory pingReplyFactory, QueryRequestFactory queryRequestFactory, QueryReplyFactory queryReplyFactory, VendorMessageFactory vendorMessageFactory, PingRequestFactory pingRequestFactory) {
        this.pingReplyFactory = pingReplyFactory;
        this.queryRequestFactory = queryRequestFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.vendorMessageFactory = vendorMessageFactory;
        this.pingRequestFactory = pingRequestFactory;
    }

    public void bind(MessageFactory messageFactory) {
        messageFactory.setParser((byte)0, new PingRequestParser());
        messageFactory.setParser((byte)1, new PingReplyParser());
        messageFactory.setParser((byte)-128, new QueryRequestParser());
        messageFactory.setParser((byte)-127, new QueryReplyParser());
        messageFactory.setParser((byte)64, new PushRequestParser());
        messageFactory.setParser((byte)48, new RouteTableUpdateParser());
        messageFactory.setParser((byte)49, new VendorMessageParser());
        messageFactory.setParser((byte)50, new VendorMessageStableParser());
    }

    private class VendorMessageStableParser
    extends GnutellaMessageParser {
        private VendorMessageStableParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.vendorMessageFactory.deriveVendorMessage(guid, ttl, hops, payload, network);
        }
    }

    private class VendorMessageParser
    extends GnutellaMessageParser {
        private VendorMessageParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.vendorMessageFactory.deriveVendorMessage(guid, ttl, hops, payload, network);
        }
    }

    private static class RouteTableUpdateParser
    extends GnutellaMessageParser {
        private RouteTableUpdateParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            return RouteTableMessage.read(guid, ttl, hops, payload, network);
        }
    }

    private static class PushRequestParser
    extends GnutellaMessageParser {
        private PushRequestParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            return new PushRequestImpl(guid, ttl, hops, payload, network);
        }
    }

    private class QueryReplyParser
    extends GnutellaMessageParser {
        private QueryReplyParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            if (payload.length < 26) {
                throw new BadPacketException("Query reply too short: " + payload.length);
            }
            return MessageParserBinderImpl.this.queryReplyFactory.createFromNetwork(guid, ttl, hops, payload, network);
        }
    }

    private class QueryRequestParser
    extends GnutellaMessageParser {
        private QueryRequestParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            if (payload.length < 3) {
                throw new BadPacketException("Query request too short: " + payload.length);
            }
            return MessageParserBinderImpl.this.queryRequestFactory.createNetworkQuery(guid, ttl, hops, payload, network);
        }
    }

    private class PingReplyParser
    extends GnutellaMessageParser {
        private PingReplyParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.pingReplyFactory.createFromNetwork(guid, ttl, hops, payload, network);
        }
    }

    private class PingRequestParser
    extends GnutellaMessageParser {
        private PingRequestParser() {
        }

        protected Message parse(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.pingRequestFactory.createFromNetwork(guid, ttl, hops, payload, network);
        }
    }

    public static abstract class GnutellaMessageParser
    implements MessageFactory.MessageParser {
        public Message parse(byte[] header, byte[] payload, Message.Network network, byte max, SocketAddress address) throws BadPacketException, IOException {
            byte func = header[16];
            byte ttl = header[17];
            byte hops = header[18];
            if (hops < 0) {
                badHops++;
                throw new BadPacketException("Negative (or very large) hops");
            }
            if (ttl < 0) {
                badTTL++;
                throw new BadPacketException("Negative (or very large) TTL");
            }
            if (hops > max && func != 1) {
                highHops++;
                throw new BadPacketException("func: " + func + ", ttl: " + ttl + ", hops: " + hops);
            }
            if (ttl + hops > max && func != 1) {
                adjustings++;
                ttl = (byte)(max - hops);
                assert (ttl >= 0);
            } else {
                parsings++;
            }
            byte[] guid = new byte[16];
            System.arraycopy(header, 0, guid, 0, guid.length);
            return this.parse(guid, ttl, hops, payload, network);
        }

        protected abstract Message parse(byte[] var1, byte var2, byte var3, byte[] var4, Message.Network var5) throws BadPacketException;
    }
}

