/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingReplyImpl
extends AbstractMessage
implements IpPort,
Connectable,
PingReply {
    private final List<IpPort> PACKED_IP_PORTS;
    private final List<IpPort> PACKED_DHT_IP_PORTS;
    private final List<IpPort> PACKED_UDP_HOST_CACHES;
    private final String UDP_CACHE_ADDRESS;
    private final int FREE_ULTRAPEER_SLOTS;
    private final int FREE_LEAF_SLOTS;
    private final byte[] PAYLOAD;
    private final InetAddress IP;
    private final int PORT;
    private final InetAddress MY_IP;
    private final int MY_PORT;
    private final long FILES;
    private final long KILOBYTES;
    private final int DAILY_UPTIME;
    private final boolean SUPPORTS_UNICAST;
    private final String VENDOR;
    private final int VENDOR_MAJOR_VERSION;
    private final int VENDOR_MINOR_VERSION;
    private final AddressSecurityToken QUERY_KEY;
    private final int DHT_VERSION;
    private final DHTManager.DHTMode DHT_MODE;
    private final boolean TLS_CAPABLE;
    private final boolean HAS_GGEP_EXTENSION;
    private String CLIENT_LOCALE;
    private int FREE_LOCALE_SLOTS;

    protected PingReplyImpl(byte[] guid, byte ttl, byte hops, byte[] payload, GGEP ggep, InetAddress ip, Message.Network network, MACCalculatorRepositoryManager manager, NetworkInstanceUtils networkInstanceUtils) throws BadPacketException {
        super(guid, (byte)1, ttl, hops, payload.length, network);
        this.PAYLOAD = payload;
        this.PORT = ByteOrder.ushort2int(ByteOrder.leb2short(this.PAYLOAD, 0));
        this.FILES = ByteOrder.uint2long(ByteOrder.leb2int(this.PAYLOAD, 6));
        this.KILOBYTES = ByteOrder.uint2long(ByteOrder.leb2int(this.PAYLOAD, 10));
        this.IP = ip;
        int dailyUptime = -1;
        boolean supportsUnicast = false;
        String vendor = "";
        int vendorMajor = -1;
        int vendorMinor = -1;
        int freeLeafSlots = -1;
        int freeUltrapeerSlots = -1;
        AddressSecurityToken key = null;
        boolean tlsCapable = false;
        String locale = ApplicationSettings.DEFAULT_LOCALE.getValue();
        int slots = -1;
        InetAddress myIP = null;
        int myPort = 0;
        List<IpPort> packedIPs = Collections.emptyList();
        List<Object> packedDHTIPs = Collections.emptyList();
        List<Object> packedCaches = Collections.emptyList();
        String cacheAddress = null;
        int dhtVersion = -1;
        DHTManager.DHTMode dhtMode = null;
        if (ggep != null) {
            Object data;
            block46: {
                byte[] bytes;
                if (ggep.hasKey("DU")) {
                    try {
                        dailyUptime = ggep.getInt("DU");
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                supportsUnicast = ggep.hasKey("GUE");
                if (ggep.hasKey("QK")) {
                    try {
                        bytes = ggep.getBytes("QK");
                        key = new AddressSecurityToken(bytes, manager);
                    }
                    catch (InvalidSecurityTokenException e) {
                        throw new BadPacketException("invalid query key");
                    }
                    catch (BadGGEPPropertyException e) {
                        throw new BadPacketException("invalid query key");
                    }
                }
                if (ggep.hasKey("UP")) {
                    try {
                        bytes = ggep.getBytes("UP");
                        if (bytes.length >= 3) {
                            freeLeafSlots = bytes[1];
                            freeUltrapeerSlots = bytes[2];
                        }
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                if (ggep.hasKey("DHT")) {
                    try {
                        bytes = ggep.getBytes("DHT");
                        if (bytes.length >= 3) {
                            dhtVersion = ByteOrder.ushort2int(ByteOrder.beb2short(bytes, 0));
                            byte mode = (byte)(bytes[2] & 0xF);
                            dhtMode = DHTManager.DHTMode.valueOf(mode);
                            if (dhtMode == null) {
                                dhtVersion = -1;
                            }
                        }
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                if (ggep.hasKey("LOC")) {
                    try {
                        bytes = ggep.getBytes("LOC");
                        if (bytes.length >= 2) {
                            locale = new String(bytes, 0, 2);
                        }
                        if (bytes.length >= 3) {
                            slots = ByteOrder.ubyte2int(bytes[2]);
                        }
                    }
                    catch (BadGGEPPropertyException e) {
                        // empty catch block
                    }
                }
                if (ggep.hasKey("IP")) {
                    try {
                        data = ggep.getBytes("IP");
                        byte[] myip = new byte[4];
                        if (((byte[])data).length >= 6) {
                            System.arraycopy(data, 0, myip, 0, 4);
                        }
                        if (!NetworkUtils.isValidAddress(myip)) break block46;
                        try {
                            myIP = InetAddress.getByAddress(myip);
                            myPort = ByteOrder.ushort2int(ByteOrder.leb2short(data, 4));
                            if (networkInstanceUtils.isPrivateAddress(myIP) || !NetworkUtils.isValidPort(myPort)) {
                                myIP = null;
                                myPort = 0;
                            }
                        }
                        catch (UnknownHostException bad) {}
                    }
                    catch (BadGGEPPropertyException ignored) {
                        // empty catch block
                    }
                }
            }
            if (ggep.hasKey("UDPHC")) {
                cacheAddress = "";
                try {
                    cacheAddress = ggep.getString("UDPHC");
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
            if (ggep.hasKey("IPP")) {
                try {
                    data = ggep.getBytes("IPP");
                    packedIPs = NetworkUtils.unpackIps(data);
                }
                catch (BadGGEPPropertyException bad) {
                }
                catch (InvalidDataException bpe) {
                    // empty catch block
                }
                if (ggep.hasKey("IPP_TLS")) {
                    try {
                        data = ggep.getBytes("IPP_TLS");
                        packedIPs = this.decoratePackedIPs((byte[])data, packedIPs);
                    }
                    catch (BadGGEPPropertyException bad) {
                        // empty catch block
                    }
                }
            }
            if (ggep.hasKey("DHTIPP")) {
                try {
                    data = ggep.getBytes("DHTIPP");
                    packedDHTIPs = NetworkUtils.unpackIps(data);
                }
                catch (BadGGEPPropertyException bad) {
                }
                catch (InvalidDataException bpe) {
                    // empty catch block
                }
            }
            if (ggep.hasKey("PHC")) {
                try {
                    data = ggep.getString("PHC");
                    packedCaches = this.listCaches((String)data);
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
            tlsCapable = ggep.hasKey("TLS");
        }
        this.MY_IP = myIP;
        this.MY_PORT = myPort;
        this.HAS_GGEP_EXTENSION = ggep != null;
        this.DAILY_UPTIME = dailyUptime;
        this.SUPPORTS_UNICAST = supportsUnicast;
        this.VENDOR = vendor;
        this.VENDOR_MAJOR_VERSION = vendorMajor;
        this.VENDOR_MINOR_VERSION = vendorMinor;
        this.QUERY_KEY = key;
        this.FREE_LEAF_SLOTS = freeLeafSlots;
        this.FREE_ULTRAPEER_SLOTS = freeUltrapeerSlots;
        this.CLIENT_LOCALE = locale;
        this.FREE_LOCALE_SLOTS = slots;
        this.UDP_CACHE_ADDRESS = cacheAddress != null && "".equals(cacheAddress) ? this.getAddress() : cacheAddress;
        this.PACKED_IP_PORTS = packedIPs;
        this.PACKED_DHT_IP_PORTS = packedDHTIPs;
        this.PACKED_UDP_HOST_CACHES = packedCaches;
        this.DHT_VERSION = dhtVersion;
        this.DHT_MODE = dhtMode;
        this.TLS_CAPABLE = tlsCapable;
    }

    private List<IpPort> decoratePackedIPs(byte[] tlsData, List<IpPort> hosts) {
        if (tlsData.length == 0) {
            return hosts;
        }
        ArrayList<IpPort> decorated = null;
        BitNumbers tlsBits = new BitNumbers(tlsData);
        int hostIdx = 0;
        for (IpPort next : hosts) {
            if (tlsBits.isSet(hostIdx)) {
                ExtendedEndpoint ep = new ExtendedEndpoint(next.getInetAddress(), next.getPort());
                ep.setTLSCapable(true);
                if (decorated == null) {
                    decorated = new ArrayList<IpPort>(hosts.size());
                    decorated.addAll(hosts.subList(0, hostIdx));
                }
                decorated.add(ep);
            } else if (decorated != null) {
                decorated.add(next);
            }
            if (hostIdx >= tlsBits.getMax()) {
                if (decorated == null || hostIdx + 1 >= hosts.size()) break;
                decorated.addAll(hosts.subList(hostIdx + 1, hosts.size()));
                break;
            }
            ++hostIdx;
        }
        if (decorated != null) {
            assert (decorated.size() == hosts.size()) : "decorated: " + decorated + ", hosts: " + hosts;
            return decorated;
        }
        return hosts;
    }

    @Override
    public boolean hasFreeSlots() {
        return this.hasFreeLeafSlots() || this.hasFreeUltrapeerSlots();
    }

    @Override
    public boolean hasFreeLeafSlots() {
        return this.FREE_LEAF_SLOTS > 0;
    }

    @Override
    public boolean hasFreeUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS > 0;
    }

    @Override
    public int getNumLeafSlots() {
        return this.FREE_LEAF_SLOTS;
    }

    @Override
    public int getNumUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS;
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.PAYLOAD);
    }

    @Override
    public int getPort() {
        return this.PORT;
    }

    @Override
    public String getAddress() {
        return this.IP.getHostAddress();
    }

    @Override
    public byte[] getIPBytes() {
        byte[] ip = new byte[]{this.PAYLOAD[2], this.PAYLOAD[3], this.PAYLOAD[4], this.PAYLOAD[5]};
        return ip;
    }

    @Override
    public long getFiles() {
        return this.FILES;
    }

    @Override
    public long getKbytes() {
        return this.KILOBYTES;
    }

    @Override
    public int getDailyUptime() {
        return this.DAILY_UPTIME;
    }

    @Override
    public boolean supportsUnicast() {
        return this.SUPPORTS_UNICAST;
    }

    @Override
    public AddressSecurityToken getQueryKey() {
        return this.QUERY_KEY;
    }

    @Override
    public List<IpPort> getPackedIPPorts() {
        return this.PACKED_IP_PORTS;
    }

    @Override
    public List<IpPort> getPackedDHTIPPorts() {
        return this.PACKED_DHT_IP_PORTS;
    }

    @Override
    public List<IpPort> getPackedUDPHostCaches() {
        return this.PACKED_UDP_HOST_CACHES;
    }

    @Override
    public DHTManager.DHTMode getDHTMode() {
        return this.DHT_MODE;
    }

    @Override
    public int getDHTVersion() {
        return this.DHT_VERSION;
    }

    @Override
    public boolean hasGGEPExtension() {
        return this.HAS_GGEP_EXTENSION;
    }

    private List<IpPort> listCaches(String allCaches) {
        LinkedList<IpPortImpl> theCaches = new LinkedList<IpPortImpl>();
        StringTokenizer st = new StringTokenizer(allCaches, "\n");
        while (st.hasMoreTokens()) {
            int port;
            int i;
            String next;
            block7: {
                next = st.nextToken();
                i = next.indexOf("&");
                if (i != -1) {
                    next = next.substring(0, i);
                }
                i = next.indexOf(":");
                port = 6346;
                if (i == 0 || i == next.length()) continue;
                if (i != -1) {
                    try {
                        port = Integer.valueOf(next.substring(i + 1));
                        break block7;
                    }
                    catch (NumberFormatException invalid) {
                        continue;
                    }
                }
                i = next.length();
            }
            if (!NetworkUtils.isValidPort(port)) continue;
            String host = next.substring(0, i);
            try {
                theCaches.add(new IpPortImpl(host, port));
            }
            catch (UnknownHostException invalid) {}
        }
        return Collections.unmodifiableList(theCaches);
    }

    @Override
    public boolean isUltrapeer() {
        long kb = this.getKbytes();
        if (kb < 8L) {
            return false;
        }
        return PingReplyImpl.isPowerOf2(ByteOrder.long2int(kb));
    }

    public static boolean isPowerOf2(int x) {
        if (x <= 0) {
            return false;
        }
        return (x & x - 1) == 0;
    }

    @Override
    public String toString() {
        return "PingReply(" + this.getAddress() + ":" + this.getPort() + ", free ultrapeers slots: " + this.hasFreeUltrapeerSlots() + ", free leaf slots: " + this.hasFreeLeafSlots() + ", vendor: " + this.VENDOR + " " + this.VENDOR_MAJOR_VERSION + "." + this.VENDOR_MINOR_VERSION + ", " + super.toString() + ", locale : " + this.CLIENT_LOCALE + ")";
    }

    @Override
    public InetAddress getInetAddress() {
        return this.IP;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public InetAddress getMyInetAddress() {
        return this.MY_IP;
    }

    @Override
    public int getMyPort() {
        return this.MY_PORT;
    }

    @Override
    public String getClientLocale() {
        return this.CLIENT_LOCALE;
    }

    @Override
    public int getNumFreeLocaleSlots() {
        return this.FREE_LOCALE_SLOTS;
    }

    @Override
    public boolean isUDPHostCache() {
        return this.UDP_CACHE_ADDRESS != null;
    }

    @Override
    public String getUDPCacheAddress() {
        return this.UDP_CACHE_ADDRESS;
    }

    @Override
    public boolean isTLSCapable() {
        return this.TLS_CAPABLE;
    }

    @Override
    public byte[] getPayload() {
        return this.PAYLOAD;
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return PingReply.class;
    }
}

